/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.transducer;

import java.util.Arrays;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.AutomatonCreator;
import net.automatalib.automaton.CompactTransition;
import net.automatalib.automaton.base.AbstractCompact;
import net.automatalib.automaton.base.AbstractCompactDeterministic;
import net.automatalib.automaton.transducer.MutableMealyMachine;
import net.automatalib.automaton.transducer.StateLocalInputMealyMachine;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CompactMealy<I, O>
extends AbstractCompactDeterministic<I, CompactTransition<O>, Void, O>
implements MutableMealyMachine<Integer, I, CompactTransition<O>, O>,
StateLocalInputMealyMachine<Integer, I, CompactTransition<O>, O> {
    private int[] transitions;
    private @Nullable Object[] outputs;

    public CompactMealy(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        super(alphabet, stateCapacity, resizeFactor);
        int size = stateCapacity * this.numInputs();
        this.transitions = new int[size];
        this.outputs = new Object[size];
        Arrays.fill(this.transitions, -1);
    }

    public CompactMealy(Alphabet<I> alphabet, int stateCapacity) {
        this(alphabet, stateCapacity, 1.5f);
    }

    public CompactMealy(Alphabet<I> alphabet) {
        this(alphabet, 11, 1.5f);
    }

    public CompactMealy(CompactMealy<I, O> other) {
        this(other.getInputAlphabet(), other);
    }

    protected CompactMealy(Alphabet<I> alphabet, CompactMealy<?, O> other) {
        super(alphabet, (AbstractCompactDeterministic<?, ?, ?, ?>)other);
        this.transitions = (int[])other.transitions.clone();
        this.outputs = (Object[])other.outputs.clone();
    }

    @Override
    protected void updateTransitionStorage(AbstractCompact.Payload payload) {
        this.transitions = this.updateTransitionStorage(this.transitions, -1, payload);
        this.outputs = this.updateTransitionStorage(this.outputs, null, payload);
    }

    public O getTransitionOutput(CompactTransition<O> transition) {
        return transition.getProperty();
    }

    public O getTransitionProperty(CompactTransition<O> transition) {
        return transition.getProperty();
    }

    public void setTransitionProperty(CompactTransition<O> transition, O property) {
        transition.setProperty(property);
        if (transition.isAutomatonTransition()) {
            this.outputs[transition.getMemoryIdx()] = property;
        }
    }

    public void setTransitionOutput(CompactTransition<O> transition, O output) {
        this.setTransitionProperty(transition, output);
    }

    public void removeAllTransitions(Integer state) {
        int lower = state * this.numInputs();
        int upper = lower + this.numInputs();
        Arrays.fill(this.transitions, lower, upper, -1);
        Arrays.fill(this.outputs, lower, upper, null);
    }

    public int getIntSuccessor(CompactTransition<O> transition) {
        return transition.getSuccId();
    }

    public CompactTransition<O> createTransition(int succId, O property) {
        return new CompactTransition<O>(succId, property);
    }

    @Override
    public void setStateProperty(int state, Void property) {
    }

    public Void getStateProperty(int stateId) {
        return null;
    }

    @Override
    public void setTransition(int state, int input, @Nullable CompactTransition<O> transition) {
        if (transition == null) {
            this.setTransition(state, input, -1, (O)null);
        } else {
            this.setTransition(state, input, transition.getSuccId(), transition.getProperty());
            transition.setMemoryIdx(this.toMemoryIndex(state, input));
        }
    }

    @Override
    public void setTransition(int state, int input, int successor, @Nullable O property) {
        int idx = this.toMemoryIndex(state, input);
        this.transitions[idx] = successor;
        this.outputs[idx] = property;
    }

    @Override
    public void clear() {
        int endIdx = this.size() * this.numInputs();
        Arrays.fill(this.transitions, 0, endIdx, -1);
        Arrays.fill(this.outputs, 0, endIdx, null);
        super.clear();
    }

    @Override
    public @Nullable CompactTransition<O> getTransition(int state, int input) {
        int idx = this.toMemoryIndex(state, input);
        int succ = this.transitions[idx];
        if (succ == -1) {
            return null;
        }
        Object output = this.outputs[idx];
        return new CompactTransition<Object>(idx, succ, output);
    }

    public static final class Creator<I, O>
    implements AutomatonCreator<CompactMealy<I, O>, I> {
        public CompactMealy<I, O> createAutomaton(Alphabet<I> alphabet, int sizeHint) {
            return new CompactMealy(alphabet, sizeHint);
        }

        public CompactMealy<I, O> createAutomaton(Alphabet<I> alphabet) {
            return new CompactMealy(alphabet);
        }
    }
}

