/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.base;

import java.util.Collection;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.automaton.MutableAutomaton;
import net.automatalib.automaton.ShrinkableAutomaton;
import net.automatalib.automaton.UniversalFiniteAlphabetAutomaton;
import net.automatalib.automaton.base.AbstractFastState;
import net.automatalib.automaton.concept.StateIDs;
import net.automatalib.automaton.concept.StateLocalInput;
import net.automatalib.common.util.mapping.ArrayMapping;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.common.util.nid.DynamicList;
import net.automatalib.common.util.nid.IDChangeListener;
import net.automatalib.common.util.nid.IDChangeNotifier;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractFastMutable<S extends AbstractFastState<?>, I, T, SP, TP>
implements ShrinkableAutomaton<S, I, T, SP, TP>,
UniversalFiniteAlphabetAutomaton<S, I, T, SP, TP>,
StateIDs<S>,
SupportsGrowingAlphabet<I>,
StateLocalInput<S, I> {
    protected final Alphabet<I> inputAlphabet;
    private final DynamicList<S> states = new DynamicList();
    private final IDChangeNotifier<S> tracker = new IDChangeNotifier();

    public AbstractFastMutable(Alphabet<I> inputAlphabet) {
        this.inputAlphabet = inputAlphabet;
    }

    public int getStateId(S state) {
        return state.getId();
    }

    public S getState(int id) {
        return (S)((Object)((AbstractFastState)this.states.get(id)));
    }

    public S addState(@Nullable SP property) {
        S newState = this.createState(property);
        this.states.add(newState);
        return newState;
    }

    public void removeAllTransitions(S state) {
        ((AbstractFastState)((Object)state)).clearTransitionObjects();
    }

    protected abstract S createState(@Nullable SP var1);

    public void removeState(S state, @Nullable S replacement) {
        ShrinkableAutomaton.unlinkState((MutableAutomaton)this, state, replacement, this.inputAlphabet);
        this.states.remove(state, this.tracker);
    }

    public void clear() {
        this.states.clear();
    }

    public Alphabet<I> getInputAlphabet() {
        return this.inputAlphabet;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public <V> MutableMapping<S, V> createDynamicStateMapping() {
        @Nullable ArrayMapping mapping = new ArrayMapping(this.size());
        this.tracker.addListener((IDChangeListener)mapping, true);
        return mapping;
    }

    public void addAlphabetSymbol(I symbol) {
        if (!this.inputAlphabet.containsSymbol(symbol)) {
            Alphabets.toGrowingAlphabetOrThrowException(this.inputAlphabet).addSymbol(symbol);
        }
        int newAlphabetSize = this.inputAlphabet.size();
        for (AbstractFastState s : this.getStates()) {
            s.ensureInputCapacity(newAlphabetSize);
        }
    }

    public Collection<S> getStates() {
        return this.states;
    }

    public StateIDs<S> stateIDs() {
        return this;
    }
}

