/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton.base;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.base.AbstractCompact;
import net.automatalib.common.util.collection.PositiveIntSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractCompactSimpleNondet<I, SP>
extends AbstractCompact<I, Integer, SP, Void> {
    private final BitSet initial;
    private @Nullable BitSet[] transitions;

    public AbstractCompactSimpleNondet(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        super(alphabet, stateCapacity, resizeFactor);
        this.transitions = new BitSet[stateCapacity * this.numInputs()];
        this.initial = new BitSet();
    }

    protected AbstractCompactSimpleNondet(Alphabet<I> alphabet, AbstractCompactSimpleNondet<?, ?> other) {
        super(alphabet, other);
        this.transitions = (BitSet[])other.transitions.clone();
        for (int i = 0; i < this.transitions.length; ++i) {
            BitSet tgts = this.transitions[i];
            if (tgts == null) continue;
            this.transitions[i] = (BitSet)tgts.clone();
        }
        this.initial = (BitSet)other.initial.clone();
    }

    @Override
    protected void updateTransitionStorage(AbstractCompact.Payload payload) {
        this.transitions = this.updateTransitionStorage(this.transitions, BitSet[]::new, null, payload);
    }

    public Void getTransitionProperty(Integer transition) {
        return null;
    }

    public void setInitial(Integer state, boolean initial) {
        this.setInitial((int)state, initial);
    }

    public void setInitial(int state, boolean initial) {
        if (initial) {
            this.initial.set(state);
        } else {
            this.initial.clear(state);
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.transitions, 0, this.size() * this.numInputs(), null);
        this.initial.clear();
        super.clear();
    }

    public void setTransitionProperty(Integer transition, Void property) {
    }

    public void removeTransition(Integer state, I input, Integer transition) {
        this.removeTransition((int)state, input, (int)transition);
    }

    public void removeTransition(int stateId, I input, int successorId) {
        this.removeTransition(stateId, this.getSymbolIndex(input), successorId);
    }

    public void removeTransition(int stateId, int inputIdx, int successorId) {
        BitSet successors = this.transitions[this.toMemoryIndex(stateId, inputIdx)];
        if (successors != null) {
            successors.clear(successorId);
        }
    }

    public void removeAllTransitions(Integer state, I input) {
        this.removeAllTransitions((int)state, input);
    }

    public void removeAllTransitions(int stateId, I input) {
        this.removeAllTransitions(stateId, this.getSymbolIndex(input));
    }

    public void removeAllTransitions(int stateId, int inputIdx) {
        this.transitions[this.toMemoryIndex((int)stateId, (int)inputIdx)] = null;
    }

    public void removeAllTransitions(Integer state) {
        this.removeAllTransitions((int)state);
    }

    public void removeAllTransitions(int state) {
        int lower = state * this.numInputs();
        int upper = lower + this.numInputs();
        Arrays.fill(this.transitions, lower, upper, null);
    }

    public void addTransition(Integer state, I input, Integer transition) {
        this.addTransition((int)state, input, (int)transition);
    }

    public void addTransition(int stateId, I input, int succId) {
        this.addTransition(stateId, this.getSymbolIndex(input), succId);
    }

    public void addTransition(int stateId, int inputIdx, int succId) {
        int transIdx = this.toMemoryIndex(stateId, inputIdx);
        BitSet successors = this.transitions[transIdx];
        if (successors == null) {
            this.transitions[transIdx] = successors = new BitSet();
        }
        successors.set(succId);
    }

    public Integer copyTransition(Integer trans, Integer succ) {
        return succ;
    }

    public Integer createTransition(Integer successor, Void properties) {
        return successor;
    }

    public void setTransitions(Integer state, I input, Collection<? extends Integer> transitions) {
        this.setTransitions((int)state, input, transitions);
    }

    public void setTransitions(int state, I input, Collection<? extends Integer> successors) {
        this.setTransitions(state, this.getSymbolIndex(input), successors);
    }

    public void setTransitions(int state, int inputIdx, Collection<? extends Integer> successors) {
        int transIdx = this.toMemoryIndex(state, inputIdx);
        BitSet succs = this.transitions[transIdx];
        if (succs == null) {
            this.transitions[transIdx] = succs = new BitSet();
        } else {
            succs.clear();
        }
        successors.forEach(succs::set);
    }

    public Integer getSuccessor(Integer transition) {
        return transition;
    }

    public Collection<Integer> getTransitions(Integer state, I input) {
        return this.getTransitions((int)state, input);
    }

    public Set<Integer> getTransitions(int state, I input) {
        return this.getTransitions(state, this.getSymbolIndex(input));
    }

    public Set<Integer> getTransitions(int state, int inputIdx) {
        BitSet transition = this.transitions[this.toMemoryIndex(state, inputIdx)];
        return transition == null ? Collections.emptySet() : new PositiveIntSet(transition);
    }

    public Set<Integer> getInitialStates() {
        return new PositiveIntSet(this.initial);
    }
}

