/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.alphabet;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.automatalib.alphabet.AbstractAlphabet;

public class MapAlphabet<I>
extends AbstractAlphabet<I> {
    protected final List<I> symbols;
    protected final Map<I, Integer> indexMap;

    public MapAlphabet(Collection<? extends I> symbols) {
        this.symbols = new ArrayList<I>(symbols);
        this.indexMap = Maps.newHashMapWithExpectedSize((int)symbols.size());
        int i = 0;
        for (I sym : this.symbols) {
            this.indexMap.put(sym, i++);
        }
    }

    MapAlphabet() {
        this.symbols = new ArrayList<I>();
        this.indexMap = new HashMap<I, Integer>();
    }

    @Override
    public int size() {
        return this.symbols.size();
    }

    public I getSymbol(int index) {
        return this.symbols.get(index);
    }

    public int getSymbolIndex(I symbol) {
        Integer result = this.indexMap.get(symbol);
        if (result == null) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is not contained in the alphabet");
        }
        return result;
    }

    public boolean containsSymbol(I symbol) {
        return this.indexMap.containsKey(symbol);
    }
}

