/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.alphabet;

import java.util.Arrays;
import java.util.List;
import net.automatalib.alphabet.GrowingAlphabet;
import net.automatalib.common.util.nid.DynamicList;
import net.automatalib.common.util.nid.MutableNumericID;

public class FastAlphabet<I extends MutableNumericID>
extends DynamicList<I>
implements GrowingAlphabet<I> {
    public FastAlphabet() {
    }

    @SafeVarargs
    public FastAlphabet(I ... symbols) {
        this(Arrays.asList(symbols));
    }

    public FastAlphabet(List<? extends I> symbols) {
        super(symbols);
    }

    public int addSymbol(I a) {
        this.add((MutableNumericID)a);
        return a.getId();
    }

    public I getSymbol(int index) {
        return (I)this.get(index);
    }

    public int getSymbolIndex(I symbol) {
        int id = symbol.getId();
        if (id < 0 || id >= this.size() || this.get(id) != symbol) {
            throw new IllegalArgumentException("Invalid symbol: " + symbol + " does not belong to this alphabet");
        }
        return id;
    }

    public int compare(I o1, I o2) {
        return o1.getId() - o2.getId();
    }

    public boolean containsSymbol(I symbol) {
        int index = symbol.getId();
        return index >= 0 && index < this.size() && this.get(index) == symbol;
    }

    public FastAlphabet<I> reversed() {
        return new FastAlphabet<I>(){

            @Override
            public boolean containsSymbol(I symbol) {
                return FastAlphabet.this.containsSymbol(symbol);
            }

            @Override
            public I getSymbol(int index) {
                return FastAlphabet.this.getSymbol(FastAlphabet.this.size() - 1 - index);
            }

            @Override
            public int getSymbolIndex(I symbol) {
                return FastAlphabet.this.size() - 1 - FastAlphabet.this.getSymbolIndex(symbol);
            }

            public int size() {
                return FastAlphabet.this.size();
            }

            @Override
            public int compare(I o1, I o2) {
                return FastAlphabet.this.compare(o2, o1);
            }
        };
    }
}

