/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.vpda;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.automatalib.commons.smartcollections.ArrayStorage;
import net.automatalib.words.VPDAlphabet;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Location {
    private final ArrayStorage<Location> intSuccessors;
    private final ArrayStorage<@Nullable List<@Nullable Location>> returnSuccessors;
    private final int index;
    private boolean accepting;

    public Location(VPDAlphabet<?> alphabet, int index, boolean accepting) {
        this.index = index;
        this.accepting = accepting;
        this.intSuccessors = new ArrayStorage(alphabet.getNumInternals());
        this.returnSuccessors = new ArrayStorage(alphabet.getNumReturns(), ArrayList::new);
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isAccepting() {
        return this.accepting;
    }

    public void setAccepting(boolean accepting) {
        this.accepting = accepting;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable Location getReturnSuccessor(int retSymId, int stackSym) {
        @Nullable @Nullable List succList = (List)this.returnSuccessors.get(retSymId);
        if (succList != null && stackSym < succList.size()) {
            return (Location)succList.get(stackSym);
        }
        return null;
    }

    public void setReturnSuccessor(int retSymId, int stackSym, Location succ) {
        int numSuccs;
        @Nullable ArrayList<@Nullable Location> succList = (ArrayList<Location>)this.returnSuccessors.get(retSymId);
        if (succList == null) {
            succList = new ArrayList<Location>(stackSym + 1);
            this.returnSuccessors.set(retSymId, succList);
        }
        if ((numSuccs = succList.size()) <= stackSym) {
            succList.addAll(Collections.nCopies(stackSym + 1 - numSuccs, null));
        }
        succList.set(stackSym, succ);
    }

    public Location getInternalSuccessor(int intSymId) {
        return (Location)this.intSuccessors.get(intSymId);
    }

    public void setInternalSuccessor(int intSymId, Location succ) {
        this.intSuccessors.set(intSymId, (Object)succ);
    }
}

