/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.fsa.impl.compact;

import java.util.BitSet;
import net.automatalib.automata.AutomatonCreator;
import net.automatalib.automata.base.compact.AbstractCompactSimpleDeterministic;
import net.automatalib.automata.fsa.MutableDFA;
import net.automatalib.commons.util.WrapperUtil;
import net.automatalib.words.Alphabet;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CompactDFA<I>
extends AbstractCompactSimpleDeterministic<I, Boolean>
implements MutableDFA<Integer, I> {
    private final BitSet acceptance;

    public CompactDFA(Alphabet<I> alphabet) {
        this(alphabet, 11, 1.5f);
    }

    public CompactDFA(Alphabet<I> alphabet, int stateCapacity) {
        this(alphabet, stateCapacity, 1.5f);
    }

    public CompactDFA(Alphabet<I> alphabet, float resizeFactor) {
        this(alphabet, 11, resizeFactor);
    }

    public CompactDFA(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        super(alphabet, stateCapacity, resizeFactor);
        this.acceptance = new BitSet();
    }

    public CompactDFA(CompactDFA<I> other) {
        this(other.getInputAlphabet(), other);
    }

    protected CompactDFA(Alphabet<I> alphabet, CompactDFA<?> other) {
        super(alphabet, (AbstractCompactSimpleDeterministic<?, ?>)other);
        this.acceptance = (BitSet)other.acceptance.clone();
    }

    public <I2> CompactDFA<I2> translate(Alphabet<I2> newAlphabet) {
        if (newAlphabet.size() != this.numInputs()) {
            throw new IllegalArgumentException("Alphabet sizes must match, but they do not (old/new): " + this.numInputs() + " vs. " + newAlphabet.size());
        }
        return new CompactDFA<I2>(newAlphabet, this);
    }

    public void flipAcceptance() {
        this.acceptance.flip(0, this.size());
    }

    public void setAccepting(Integer state, boolean accepting) {
        this.setAccepting((int)state, accepting);
    }

    public void setAccepting(int state, boolean accepting) {
        this.acceptance.set(state, accepting);
    }

    @Override
    public Integer addState(boolean accepting) {
        return this.addState((Object)accepting);
    }

    @Override
    public void clear() {
        this.acceptance.clear();
        super.clear();
    }

    @Override
    public void setStateProperty(int stateId, @Nullable Boolean property) {
        this.setAccepting(stateId, WrapperUtil.booleanValue((Boolean)property));
    }

    public Boolean getStateProperty(int stateId) {
        return this.isAccepting(stateId);
    }

    public boolean isAccepting(int stateId) {
        return this.acceptance.get(stateId);
    }

    public boolean isAccepting(Integer state) {
        return this.isAccepting((int)state);
    }

    public static final class Creator<I>
    implements AutomatonCreator<CompactDFA<I>, I> {
        public CompactDFA<I> createAutomaton(Alphabet<I> alphabet, int numStates) {
            return new CompactDFA<I>(alphabet, numStates);
        }

        public CompactDFA<I> createAutomaton(Alphabet<I> alphabet) {
            return new CompactDFA<I>(alphabet);
        }
    }
}

