/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automata.base.compact;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.automatalib.automata.base.compact.AbstractCompact;
import net.automatalib.words.Alphabet;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractCompactSimpleNondet<I, SP>
extends AbstractCompact<I, Integer, SP, Void> {
    protected final Set<Integer> initial;
    protected @Nullable Set<Integer>[] transitions;

    public AbstractCompactSimpleNondet(Alphabet<I> alphabet, int stateCapacity, float resizeFactor) {
        super(alphabet, stateCapacity, resizeFactor);
        this.transitions = new Set[stateCapacity * this.numInputs()];
        this.initial = new HashSet<Integer>();
    }

    protected AbstractCompactSimpleNondet(Alphabet<I> alphabet, AbstractCompactSimpleNondet<?, ?> other) {
        super(alphabet, other);
        this.transitions = (Set[])other.transitions.clone();
        for (int i = 0; i < this.transitions.length; ++i) {
            Set<Integer> tgts = this.transitions[i];
            if (tgts == null) continue;
            this.transitions[i] = new HashSet<Integer>(tgts);
        }
        this.initial = new HashSet<Integer>(other.initial);
    }

    @Override
    protected void updateTransitionStorage(AbstractCompact.Payload payload) {
        this.transitions = this.updateTransitionStorage(this.transitions, Set[]::new, null, payload);
    }

    public Void getTransitionProperty(Integer transition) {
        return null;
    }

    public void setInitial(Integer state, boolean initial) {
        this.setInitial((int)state, initial);
    }

    public void setInitial(int state, boolean initial) {
        if (initial) {
            this.initial.add(state);
        } else {
            this.initial.remove(state);
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.transitions, 0, this.size() * this.numInputs(), null);
        this.initial.clear();
        super.clear();
    }

    public void setTransitionProperty(Integer transition, Void property) {
    }

    public void removeTransition(Integer state, I input, Integer transition) {
        this.removeTransition((int)state, input, (int)transition);
    }

    public void removeTransition(int stateId, I input, int successorId) {
        this.removeTransition(stateId, this.getSymbolIndex(input), successorId);
    }

    public void removeTransition(int stateId, int inputIdx, int successorId) {
        Set<Integer> successors = this.transitions[this.toMemoryIndex(stateId, inputIdx)];
        if (successors != null) {
            successors.remove(successorId);
        }
    }

    public void removeAllTransitions(Integer state, I input) {
        this.removeAllTransitions((int)state, input);
    }

    public void removeAllTransitions(int stateId, I input) {
        this.removeAllTransitions(stateId, this.getSymbolIndex(input));
    }

    public void removeAllTransitions(int stateId, int inputIdx) {
        this.transitions[this.toMemoryIndex((int)stateId, (int)inputIdx)] = null;
    }

    public void removeAllTransitions(Integer state) {
        this.removeAllTransitions((int)state);
    }

    public void removeAllTransitions(int state) {
        int lower = state * this.numInputs();
        int upper = lower + this.numInputs();
        Arrays.fill(this.transitions, lower, upper, null);
    }

    public void addTransition(Integer state, I input, Integer transition) {
        this.addTransition((int)state, input, (int)transition);
    }

    public void addTransition(int stateId, I input, int succId) {
        this.addTransition(stateId, this.getSymbolIndex(input), succId);
    }

    public void addTransition(int stateId, int inputIdx, int succId) {
        int transIdx = this.toMemoryIndex(stateId, inputIdx);
        Set<Integer> successors = this.transitions[transIdx];
        if (successors == null) {
            this.transitions[transIdx] = successors = new HashSet<Integer>();
        }
        successors.add(succId);
    }

    public Integer copyTransition(Integer trans, Integer succ) {
        return succ;
    }

    public Integer createTransition(Integer successor, Void properties) {
        return successor;
    }

    public void setTransitions(Integer state, I input, Collection<? extends Integer> transitions) {
        this.setTransitions((int)state, input, transitions);
    }

    public void setTransitions(int state, I input, Collection<? extends Integer> successors) {
        this.setTransitions(state, this.getSymbolIndex(input), successors);
    }

    public void setTransitions(int state, int inputIdx, Collection<? extends Integer> successors) {
        int transIdx = this.toMemoryIndex(state, inputIdx);
        HashSet succs = this.transitions[transIdx];
        if (succs == null) {
            this.transitions[transIdx] = succs = Sets.newHashSetWithExpectedSize((int)successors.size());
        } else {
            succs.clear();
        }
        succs.addAll(successors);
    }

    public Integer getSuccessor(Integer transition) {
        return transition;
    }

    public Collection<Integer> getTransitions(Integer state, I input) {
        return this.getTransitions((int)state, input);
    }

    public Set<Integer> getTransitions(int state, I input) {
        return this.getTransitions(state, this.getSymbolIndex(input));
    }

    public Set<Integer> getTransitions(int state, int inputIdx) {
        Set<Integer> transition = this.transitions[this.toMemoryIndex(state, inputIdx)];
        return transition == null ? Collections.emptySet() : transition;
    }

    public Set<Integer> getInitialStates() {
        return this.initial;
    }
}

