/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.settings;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.commons.util.settings.SettingsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileSource
implements SettingsSource {
    private final File file;

    protected LocalFileSource(String fileName) {
        this(new File(fileName));
    }

    protected LocalFileSource(File file) {
        this.file = file;
    }

    @Override
    public void loadSettings(Properties properties) {
        if (!this.file.exists()) {
            return;
        }
        Logger log = LoggerFactory.getLogger(this.getClass());
        try (Reader r = IOUtil.asBufferedUTF8Reader(this.file);){
            properties.load(r);
        }
        catch (IOException ex) {
            log.warn("Could not read properties file " + this.file.getAbsolutePath() + ".", (Throwable)ex);
        }
    }

    @Override
    public int getPriority() {
        return 0x7FFFFFFE;
    }
}

