/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.settings;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.commons.util.settings.SettingsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClassPathFileSource
implements SettingsSource {
    private final String fileName;

    protected AbstractClassPathFileSource(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void loadSettings(Properties properties) {
        Logger log = LoggerFactory.getLogger(this.getClass());
        try {
            Enumeration<URL> resourceUrls = Thread.currentThread().getContextClassLoader().getResources(this.fileName);
            while (resourceUrls.hasMoreElements()) {
                URL url = resourceUrls.nextElement();
                try {
                    Reader r = IOUtil.asBufferedUTF8Reader(url.openStream());
                    Throwable throwable = null;
                    try {
                        properties.load(r);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (r == null) continue;
                        if (throwable != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        r.close();
                    }
                }
                catch (IOException ex) {
                    log.error("Could not read property file " + url + ".", (Throwable)ex);
                }
            }
        }
        catch (IOException ex) {
            log.error("Could not enumerate " + this.fileName + " files,", (Throwable)ex);
        }
    }
}

