/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.process;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.commons.util.process.InputStreamConsumer;
import net.automatalib.commons.util.process.StreamGobbler;

@ParametersAreNonnullByDefault
public final class ProcessUtil {
    private ProcessUtil() {
        throw new AssertionError();
    }

    public static int invokeProcess(String[] commandLine) throws IOException, InterruptedException {
        return ProcessUtil.invokeProcess(commandLine, null, new InputStreamConsumer.NOPConsumer());
    }

    public static int invokeProcess(String[] commandLine, Reader input) throws IOException, InterruptedException {
        return ProcessUtil.invokeProcess(commandLine, input, new InputStreamConsumer.NOPConsumer());
    }

    public static int invokeProcess(String[] commandLine, Consumer<String> consumer) throws IOException, InterruptedException {
        return ProcessUtil.invokeProcess(commandLine, null, new InputStreamConsumer.DelegatingConsumer(consumer));
    }

    public static int invokeProcess(String[] commandLine, Reader input, Consumer<String> consumer) throws IOException, InterruptedException {
        return ProcessUtil.invokeProcess(commandLine, input, new InputStreamConsumer.DelegatingConsumer(consumer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int invokeProcess(String[] commandLine, @Nullable Reader input, InputStreamConsumer consumer) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        ProcessUtil.writeProcessInput(process, input);
        consumer.consume(process.getInputStream());
        try {
            int n = process.waitFor();
            return n;
        }
        finally {
            process.destroy();
        }
    }

    public static Process buildProcess(String[] commandLine, @Nullable Reader input, @Nullable Consumer<String> stdOutConsumer, @Nullable Consumer<String> stdErrConsumer) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        Process process = processBuilder.start();
        ProcessUtil.writeProcessInput(process, input);
        if (stdOutConsumer != null) {
            StreamGobbler stdOutThread = new StreamGobbler(process.getInputStream(), new InputStreamConsumer.DelegatingConsumer(stdOutConsumer));
            stdOutThread.start();
        }
        if (stdErrConsumer != null) {
            StreamGobbler stdErrThread = new StreamGobbler(process.getErrorStream(), new InputStreamConsumer.DelegatingConsumer(stdErrConsumer));
            stdErrThread.start();
        }
        return process;
    }

    private static void writeProcessInput(Process process, @Nullable Reader input) throws IOException {
        OutputStream processInput = process.getOutputStream();
        if (input == null) {
            processInput.close();
        } else {
            Writer writer = IOUtil.asBufferedUTF8Writer(processInput);
            IOUtil.copy(input, writer);
        }
    }
}

