/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.commons.util.io.NullOutputStream;

interface InputStreamConsumer {
    public void consume(InputStream var1) throws IOException;

    public static class DelegatingConsumer
    implements InputStreamConsumer {
        private final Consumer<String> delegate;

        DelegatingConsumer(Consumer<String> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void consume(InputStream inputStream) throws IOException {
            try (BufferedReader r = new BufferedReader(IOUtil.asUTF8Reader(inputStream));){
                String line;
                while ((line = r.readLine()) != null) {
                    this.delegate.accept(line);
                }
            }
        }
    }

    public static class NOPConsumer
    implements InputStreamConsumer {
        @Override
        public void consume(InputStream inputStream) throws IOException {
            IOUtil.copy(inputStream, new NullOutputStream());
        }
    }
}

