/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.nid;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;
import net.automatalib.commons.smartcollections.ArrayWritable;
import net.automatalib.commons.smartcollections.ResizingArrayStorage;
import net.automatalib.commons.util.nid.IDChangeNotifier;
import net.automatalib.commons.util.nid.MutableNumericID;

public class DynamicList<T extends MutableNumericID>
extends AbstractList<T>
implements ArrayWritable<T>,
Serializable {
    private final ResizingArrayStorage<T> storage = new ResizingArrayStorage(MutableNumericID.class);
    private int size;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean remove(Object elem) {
        return this.remove(elem, null);
    }

    public boolean remove(Object elem, IDChangeNotifier<T> tracker) {
        if (!(elem instanceof MutableNumericID)) {
            return false;
        }
        MutableNumericID idElem = (MutableNumericID)elem;
        int idx = idElem.getId();
        T myElem = this.safeGet(idx);
        if (elem != myElem) {
            return false;
        }
        T last = this.safeGet(this.size - 1);
        --this.size;
        if (idx != this.size) {
            ((MutableNumericID[])this.storage.array)[idx] = last;
            last.setId(idx);
            if (tracker != null) {
                tracker.notifyListeners(last, idx, this.size);
            }
        }
        ((MutableNumericID[])this.storage.array)[this.size] = null;
        myElem.setId(-1);
        return true;
    }

    public T remove(int index, IDChangeNotifier<T> tracker) {
        Object elem = this.get(index);
        T last = this.safeGet(--this.size);
        if (index != this.size) {
            ((MutableNumericID[])this.storage.array)[index] = last;
            last.setId(index);
            if (tracker != null) {
                tracker.notifyListeners(last, index, this.size);
            }
        }
        ((MutableNumericID[])this.storage.array)[this.size] = null;
        elem.setId(-1);
        return (T)elem;
    }

    public T safeGet(int index) {
        if (index < 0 || index >= this.size) {
            return null;
        }
        return (T)((MutableNumericID[])this.storage.array)[index];
    }

    @Override
    public boolean add(T elem) {
        this.storage.ensureCapacity(this.size + 1);
        ((MutableNumericID[])this.storage.array)[this.size] = elem;
        elem.setId(this.size);
        ++this.size;
        return true;
    }

    @Override
    public T get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Invalid index " + index);
        }
        return (T)((MutableNumericID[])this.storage.array)[index];
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            ((MutableNumericID[])this.storage.array)[i] = null;
        }
        this.size = 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int index;

            @Override
            public boolean hasNext() {
                return this.index < DynamicList.this.size;
            }

            @Override
            public T next() {
                return DynamicList.this.get(this.index++);
            }

            @Override
            public void remove() {
                DynamicList.this.remove(--this.index);
            }
        };
    }

    public void swap(int a, int b) {
        if (a == b) {
            return;
        }
        if (a < 0 || a >= this.size) {
            throw new IndexOutOfBoundsException("Invalid index " + a);
        }
        if (b < 0 || b >= this.size) {
            throw new IndexOutOfBoundsException("Invalid index " + b);
        }
        MutableNumericID tmp = ((MutableNumericID[])this.storage.array)[a];
        ((MutableNumericID[])this.storage.array)[a] = ((MutableNumericID[])this.storage.array)[b];
        ((MutableNumericID[])this.storage.array)[b] = tmp;
        ((MutableNumericID[])this.storage.array)[a].setId(a);
        ((MutableNumericID[])this.storage.array)[b].setId(b);
    }

    public void writeToArray(int offset, Object[] array, int tgtOfs, int num) {
        System.arraycopy(this.storage.array, offset, array, tgtOfs, num);
    }
}

