/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.lib;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import net.automatalib.commons.util.lib.LoadLibraryException;
import net.automatalib.commons.util.lib.LoadPolicy;
import net.automatalib.commons.util.lib.PlatformProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibLoader {
    private static final Logger LOG = LoggerFactory.getLogger(LibLoader.class);
    private static final LibLoader INSTANCE = new LibLoader();
    private final String libPrefix;
    private final String libExtension;
    private final Path tempLibDir;
    private final Set<String> loaded = new HashSet<String>();

    private LibLoader() {
        this.libPrefix = PlatformProperties.OS_NAME.startsWith("windows") ? "" : "lib";
        this.libExtension = PlatformProperties.OS_NAME.startsWith("windows") ? "dll" : (PlatformProperties.OS_NAME.startsWith("mac") ? "dylib" : "so");
        Path tmpDir = null;
        try {
            tmpDir = Files.createTempDirectory(this.getClass().getName(), new FileAttribute[0]);
            tmpDir.toFile().deleteOnExit();
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            String[] paths = (String[])field.get(null);
            String[] newPaths = new String[paths.length + 1];
            System.arraycopy(paths, 0, newPaths, 0, paths.length);
            newPaths[paths.length] = tmpDir.toString();
            field.set(null, newPaths);
        }
        catch (IOException | IllegalAccessException | NoSuchFieldException ex) {
            LOG.error("Error setting up classloader for custom library loading.", (Throwable)ex);
            LOG.error("Loading of shipped libraries may fail");
        }
        this.tempLibDir = tmpDir;
    }

    public static LibLoader getInstance() {
        return INSTANCE;
    }

    public void loadLibrary(Class<?> clazz, String name) {
        this.loadLibrary(clazz, name, LoadPolicy.PREFER_SHIPPED);
    }

    public void loadLibrary(Class<?> clazz, String name, LoadPolicy policy) {
        if (this.loaded.contains(name)) {
            return;
        }
        switch (policy) {
            case PREFER_SHIPPED: {
                try {
                    this.loadShippedLibrary(clazz, name);
                    break;
                }
                catch (LoadLibraryException ex) {
                    try {
                        this.loadSystemLibrary(name);
                        break;
                    }
                    catch (LoadLibraryException ex2) {
                        throw ex;
                    }
                }
            }
            case PREFER_SYSTEM: {
                try {
                    this.loadSystemLibrary(name);
                    break;
                }
                catch (LoadLibraryException ex) {
                    try {
                        this.loadShippedLibrary(clazz, name);
                        break;
                    }
                    catch (LoadLibraryException ex2) {
                        throw ex;
                    }
                }
            }
            case SHIPPED_ONLY: {
                this.loadShippedLibrary(clazz, name);
                break;
            }
            case SYSTEM_ONLY: {
                this.loadSystemLibrary(name);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown policy " + (Object)((Object)policy));
            }
        }
        this.loaded.add(name);
    }

    private void loadShippedLibrary(Class<?> clazz, String name) throws LoadLibraryException {
        String libFileName = this.libPrefix + name + "." + this.libExtension;
        String libResourcePath = "/lib/" + PlatformProperties.OS_NAME + "/" + PlatformProperties.OS_ARCH + "/" + libFileName;
        InputStream libStream = clazz.getResourceAsStream(libResourcePath);
        if (libStream == null) {
            throw new LoadLibraryException("Could not find shipped library resource '" + libFileName + "'");
        }
        Path libPath = this.tempLibDir.resolve(libFileName);
        try {
            Files.copy(libStream, libPath, new CopyOption[0]);
        }
        catch (IOException ex) {
            throw new LoadLibraryException("Could not copy shipped library to local file system at '" + libPath + "': " + ex.getMessage(), ex);
        }
        libPath.toFile().deleteOnExit();
        try {
            System.load(libPath.toString());
        }
        catch (SecurityException | UnsatisfiedLinkError ex) {
            throw new LoadLibraryException(ex);
        }
    }

    private void loadSystemLibrary(String name) throws LoadLibraryException {
        try {
            System.loadLibrary(name);
        }
        catch (SecurityException | UnsatisfiedLinkError ex) {
            throw new LoadLibraryException(ex);
        }
    }
}

