/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.functions;

import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FunctionsUtil {
    private FunctionsUtil() {
        throw new AssertionError();
    }

    @Nonnull
    public static <T, R> Function<T, R> safeDefault(@Nullable Function<T, R> func) {
        if (func == null) {
            return x -> null;
        }
        return func;
    }

    @Nonnull
    public static <R> IntFunction<R> safeDefault(@Nullable IntFunction<R> func) {
        if (func == null) {
            return i -> null;
        }
        return func;
    }

    @Nonnull
    public static <T> Predicate<T> safeToTrue(@Nullable Predicate<T> func) {
        if (func == null) {
            return x -> true;
        }
        return func;
    }

    @Nonnull
    public static <T> Predicate<T> safeToFalse(@Nullable Predicate<T> func) {
        if (func == null) {
            return x -> false;
        }
        return func;
    }
}

