/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.strings;

import java.io.IOException;

public class StringIndexGenerator {
    private static final int ALPHABET_SIZE = 26;
    private final char base;

    public StringIndexGenerator(Case charCase) {
        switch (charCase) {
            case LOWER: {
                this.base = (char)97;
                break;
            }
            default: {
                this.base = (char)65;
            }
        }
    }

    public static int getIntegerIndex(String sidx) {
        int idx = 0;
        int value = 1;
        for (int i = 0; i < sidx.length(); ++i) {
            char c = sidx.charAt(i);
            idx += value * StringIndexGenerator.getInteger(c);
            value *= 26;
        }
        return idx;
    }

    private static int getInteger(char c) {
        return Character.toLowerCase(c) - 97;
    }

    public void appendStringIndex(Appendable a, int idx) throws IOException {
        int idxIter = idx;
        do {
            a.append(this.getChar(idxIter % 26));
        } while ((idxIter /= 26) > 0);
    }

    public void appendStringIndex(StringBuilder sb, int idx) {
        int idxIter = idx;
        do {
            sb.append(this.getChar(idxIter % 26));
        } while ((idxIter /= 26) > 0);
    }

    private char getChar(int idx) {
        return (char)(this.base + idx);
    }

    public String getStringIndex(int idx) {
        StringBuilder sb = new StringBuilder();
        this.appendStringIndex(sb, idx);
        return sb.toString();
    }

    public static enum Case {
        LOWER,
        UPPER;

    }
}

