/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.settings;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import net.automatalib.commons.util.settings.SettingsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClassPathFileSource
implements SettingsSource {
    private final String fileName;

    protected AbstractClassPathFileSource(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void loadSettings(Properties properties) {
        Logger log = LoggerFactory.getLogger(this.getClass());
        try {
            Enumeration<URL> resourceUrls = this.getClass().getClassLoader().getResources(this.fileName);
            while (resourceUrls.hasMoreElements()) {
                URL url = resourceUrls.nextElement();
                try {
                    BufferedInputStream is = new BufferedInputStream(url.openStream());
                    Throwable throwable = null;
                    try {
                        properties.load(is);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                catch (IOException ex) {
                    log.error("Could not read property file " + url + ".", (Throwable)ex);
                }
            }
        }
        catch (IOException ex) {
            log.error("Could not enumerate " + this.fileName + " files,", (Throwable)ex);
        }
    }
}

