/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.comparison;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.automatalib.commons.util.comparison.CanonicalComparator;
import net.automatalib.commons.util.comparison.LexComparator;
import net.automatalib.commons.util.comparison.NaturalCanonicalComparator;
import net.automatalib.commons.util.comparison.NaturalLexComparator;
import net.automatalib.commons.util.comparison.NaturalOrderingComparator;
import net.automatalib.commons.util.comparison.SafeComparator;

public final class CmpUtil {
    private CmpUtil() {
    }

    public static <U> int canonicalCompare(List<? extends U> o1, List<? extends U> o2, Comparator<? super U> elemComparator) {
        int siz2;
        int siz1 = o1.size();
        if (siz1 != (siz2 = o2.size())) {
            return siz1 - siz2;
        }
        return CmpUtil.lexCompare(o1, o2, elemComparator);
    }

    public static int canonicalCompare(int[] a1, int[] a2) {
        int ldiff = a1.length - a2.length;
        if (ldiff != 0) {
            return ldiff;
        }
        return CmpUtil.lexCompare(a1, a2);
    }

    public static <U extends Comparable<? super U>> int canonicalCompare(List<? extends U> o1, List<? extends U> o2) {
        int siz2;
        int siz1 = o1.size();
        if (siz1 != (siz2 = o2.size())) {
            return siz1 - siz2;
        }
        return CmpUtil.lexCompare(o1, o2);
    }

    public static <U> int lexCompare(Iterable<? extends U> o1, Iterable<? extends U> o2, Comparator<U> elemComparator) {
        Iterator<U> it1 = o1.iterator();
        Iterator<U> it2 = o2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            int cmp = elemComparator.compare(it1.next(), it2.next());
            if (cmp == 0) continue;
            return cmp;
        }
        if (it1.hasNext()) {
            return 1;
        }
        if (it2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static int lexCompare(int[] a1, int[] a2) {
        int i;
        int len1 = a1.length;
        int len2 = a2.length;
        for (i = 0; i < len1 && i < len2; ++i) {
            int cmp = a1[i] - a2[i];
            if (cmp == 0) continue;
            return cmp;
        }
        if (i < len1) {
            return 1;
        }
        if (i < len2) {
            return -1;
        }
        return 0;
    }

    public static <U extends Comparable<? super U>> int lexCompare(Iterable<? extends U> o1, Iterable<? extends U> o2) {
        Iterator<U> it1 = o1.iterator();
        Iterator<U> it2 = o2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            int cmp = ((Comparable)it1.next()).compareTo(it2.next());
            if (cmp == 0) continue;
            return cmp;
        }
        if (it1.hasNext()) {
            return 1;
        }
        if (it2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static <T extends Iterable<U>, U> Comparator<T> lexComparator(Comparator<U> elemComp) {
        return new LexComparator(elemComp);
    }

    public static <U extends Comparable<U>, T extends Iterable<U>> Comparator<T> lexComparator() {
        return NaturalLexComparator.getInstance();
    }

    public static <T extends List<? extends U>, U> Comparator<T> canonicalComparator(Comparator<? super U> elemComp) {
        return new CanonicalComparator(elemComp);
    }

    public static <T extends List<U>, U extends Comparable<U>> Comparator<T> canonicalComparator() {
        return NaturalCanonicalComparator.getInstance();
    }

    public static <T> Comparator<T> safeComparator(Comparator<T> baseComp, NullOrdering nullOrd) {
        return new SafeComparator<T>(baseComp, nullOrd);
    }

    public static <T extends Comparable<T>> Comparator<T> naturalOrderingComparator() {
        return NaturalOrderingComparator.getInstance();
    }

    public static enum NullOrdering {
        MIN(-1),
        MAX(1);

        public final int firstNullResult;

        private NullOrdering(int firstNullResult) {
            this.firstNullResult = firstNullResult;
        }
    }
}

