/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.collections;

import java.util.AbstractList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

final class NullList
extends AbstractList<Object>
implements RandomAccess {
    private final int size;

    NullList(int size) {
        this.size = size;
    }

    @Override
    public Object get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return null;
    }

    @Override
    public java.util.Iterator<Object> iterator() {
        return new Iterator(this.size);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return new Iterator(this.size);
    }

    @Override
    public int size() {
        return this.size;
    }

    private static final class Iterator
    implements ListIterator<Object> {
        private final int size;
        private int i;

        Iterator(int size) {
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.size;
        }

        @Override
        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.i;
            return null;
        }

        @Override
        public boolean hasPrevious() {
            return this.i > 0;
        }

        @Override
        public Object previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this.i;
            return null;
        }

        @Override
        public int nextIndex() {
            return this.i;
        }

        @Override
        public int previousIndex() {
            return this.i - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object e) {
            throw new UnsupportedOperationException();
        }
    }
}

