/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.collections;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.automatalib.commons.util.collections.AllCombinationsIterator;
import net.automatalib.commons.util.collections.ConcatIterator;
import net.automatalib.commons.util.collections.UnmodifiableIterator;

public final class IterableUtil {
    private static final Iterator<?> EMPTY_ITERATOR = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    private IterableUtil() {
    }

    @SafeVarargs
    public static <T> Iterable<T> concat(Iterable<? extends T> ... iterables) {
        return () -> {
            Iterator[] iterators = new Iterator[iterables.length];
            for (int i = 0; i < iterables.length; ++i) {
                iterators[i] = iterables[i].iterator();
            }
            return IterableUtil.concat(iterators);
        };
    }

    @SafeVarargs
    public static <T> Iterator<T> concat(Iterator<? extends T> ... iterators) {
        return new ConcatIterator<T>(iterators);
    }

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <T> Iterable<T> unmodifiableIterable(Iterable<T> iterable) {
        return () -> IterableUtil.unmodifiableIterator(iterable.iterator());
    }

    public static <T> Iterator<T> unmodifiableIterator(Iterator<T> iterator) {
        return new UnmodifiableIterator<T>(iterator);
    }

    public static <T> Iterator<List<T>> allCombinationsIterator(List<? extends Iterable<? extends T>> iterables) {
        Iterable[] target = new Iterable[iterables.size()];
        return IterableUtil.allCombinationsIterator(iterables.toArray(target));
    }

    @SafeVarargs
    public static <T> Iterator<List<T>> allCombinationsIterator(Iterable<? extends T> ... iterables) {
        return new AllCombinationsIterator<T>(iterables);
    }

    public static <T> Iterable<List<T>> allCombinations(List<? extends Iterable<? extends T>> iterables) {
        return () -> IterableUtil.allCombinationsIterator(iterables);
    }

    @SafeVarargs
    public static <T> Iterable<List<T>> allCombinations(Iterable<? extends T> ... iterables) {
        return () -> IterableUtil.allCombinationsIterator(iterables);
    }
}

