/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.collections;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.RandomAccess;
import net.automatalib.commons.util.array.ArrayWritable;
import net.automatalib.commons.util.collections.CharStringRangeIterator;
import net.automatalib.commons.util.collections.IntRange;

public class CharStringRange
extends AbstractList<String>
implements ArrayWritable<String>,
RandomAccess,
Serializable {
    private final IntRange delegate;

    public CharStringRange(char low, char high) {
        this(low, high, 1);
    }

    public CharStringRange(char low, char high, int step) {
        this(new IntRange(low, high, step));
    }

    public CharStringRange(IntRange delegate) {
        this.delegate = delegate;
    }

    @Override
    public String get(int index) {
        return String.valueOf(this.charGet(index));
    }

    public char charGet(int index) {
        int i = this.delegate.intGet(index);
        return (char)i;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null || o.getClass() != String.class) {
            return -1;
        }
        return this.indexOf((String)o);
    }

    public int indexOf(String s) {
        if (s.length() != 1) {
            return -1;
        }
        return this.delegate.indexOf(s.charAt(0));
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    public CharStringRangeIterator iterator() {
        return new CharStringRangeIterator(this.delegate.iterator());
    }

    public CharStringRangeIterator listIterator() {
        return new CharStringRangeIterator(this.delegate.listIterator());
    }

    public CharStringRangeIterator listIterator(int index) {
        return new CharStringRangeIterator(this.delegate.listIterator(index));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public void writeToArray(int offset, Object[] array, int tgtOfs, int num) {
        int si = offset;
        int ti = tgtOfs;
        for (int i = 0; i < num; ++i) {
            array[ti++] = Character.valueOf(this.charGet(si++));
        }
    }

    public char charValue(int i) {
        return (char)this.delegate.intValue(i);
    }
}

