/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.collections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class BatchingIterator<T>
implements Iterator<List<T>> {
    private final int batchSize;
    private final Iterator<T> source;
    private final List<T> batch;

    public BatchingIterator(Iterator<T> source, int batchSize) {
        this.batchSize = batchSize;
        this.source = source;
        this.batch = new ArrayList<T>(batchSize);
    }

    @Override
    public boolean hasNext() {
        return this.source.hasNext();
    }

    @Override
    public List<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.batch.clear();
        while (this.source.hasNext() && this.batch.size() < this.batchSize) {
            this.batch.add(this.source.next());
        }
        return this.batch;
    }
}

