/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractSimplifiedIterator<E>
implements Iterator<E> {
    protected E nextValue;
    private State state = State.AWAIT_NEXT;

    protected abstract boolean calculateNext();

    private boolean advance() {
        boolean ret = this.calculateNext();
        this.state = !ret ? State.FINISHED : State.HAS_NEXT;
        return ret;
    }

    @Override
    public boolean hasNext() {
        switch (this.state) {
            case AWAIT_NEXT: {
                return this.advance();
            }
            case HAS_NEXT: {
                return true;
            }
        }
        return false;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.AWAIT_NEXT;
        return this.nextValue;
    }

    private static enum State {
        AWAIT_NEXT,
        HAS_NEXT,
        FINISHED;

    }
}

