/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.array;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.automatalib.commons.util.array.ArrayIterator;
import net.automatalib.commons.util.array.WithIndexTransformer;

public class RichArray<T>
implements List<T>,
IntFunction<T>,
RandomAccess,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public final int length;
    private final T[] contents;
    private final int start;

    public RichArray(Collection<? extends T> coll) {
        this(coll.toArray(new Object[coll.size()]));
    }

    public RichArray(T[] contents) {
        this(contents, 0, contents.length);
    }

    public RichArray(T[] contents, int start, int end) {
        Preconditions.checkPositionIndexes((int)start, (int)end, (int)contents.length);
        this.contents = contents;
        this.start = start;
        this.length = end - start;
    }

    public RichArray(int length, T value) {
        this(length);
        for (int i = 0; i < length; ++i) {
            this.contents[i] = value;
        }
    }

    public RichArray(int length) {
        this(new Object[length]);
    }

    public RichArray(int length, Supplier<? extends T> valueSupp) {
        this(length);
        this.setAll(valueSupp);
    }

    public RichArray(int length, IntFunction<? extends T> initializer) {
        this(length);
        this.setAll(initializer);
    }

    public void setAll(Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier);
        int end = this.end();
        for (int i = this.start; i < end; ++i) {
            this.contents[i] = supplier.get();
        }
    }

    public void setAll(IntFunction<? extends T> generator) {
        Objects.requireNonNull(generator);
        int i = this.start;
        for (int j = 0; j < this.length; ++j) {
            this.contents[i] = generator.apply(j);
            ++i;
        }
    }

    public void setAll(T value) {
        int end = this.end();
        for (int i = this.start; i < end; ++i) {
            this.contents[i] = value;
        }
    }

    public void setAll(int startInclusive, int endExclusive, T value) {
        Preconditions.checkPositionIndexes((int)startInclusive, (int)endExclusive, (int)this.length);
        int end = this.start + endExclusive;
        for (int i = this.start + startInclusive; i < end; ++i) {
            this.contents[i] = value;
        }
    }

    public void setAll(int startInclusive, int endExclusive, IntFunction<? extends T> generator) {
        Preconditions.checkPositionIndexes((int)startInclusive, (int)endExclusive, (int)this.length);
        Objects.requireNonNull(generator);
        int i = this.start + startInclusive;
        for (int j = startInclusive; j < endExclusive; ++j) {
            this.contents[i] = generator.apply(j);
            ++i;
        }
    }

    public void setAll(int startInclusive, int endExclusive, Supplier<? extends T> supplier) {
        Preconditions.checkPositionIndexes((int)startInclusive, (int)endExclusive, (int)this.length);
        Objects.requireNonNull(supplier);
        int end = this.start + endExclusive;
        for (int i = this.start + startInclusive; i < end; ++i) {
            this.contents[i] = supplier.get();
        }
    }

    private int end() {
        return this.start + this.length;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        int end = this.end();
        for (int i = this.start; i < end; ++i) {
            hashCode = 31 * hashCode + Objects.hashCode(this.contents[i]);
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof List)) {
            return false;
        }
        return this.equals((List)o);
    }

    public boolean equals(List<?> other) {
        if (other == null) {
            return false;
        }
        if (other.getClass() == RichArray.class) {
            return this.equals((RichArray)other);
        }
        if (this.length != other.size()) {
            return false;
        }
        Iterator<?> otherIt = other.iterator();
        int end = this.end();
        for (int i = this.start; i < end; ++i) {
            assert (otherIt.hasNext());
            if (Objects.equals(this.contents[i], otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(RichArray<?> other) {
        if (other == null) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        int end = this.end();
        int i = this.start;
        int j = other.start;
        while (i < end) {
            if (!Objects.equals(this.contents[i], other.contents[j])) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public RichArray<T> clone() {
        return new RichArray<Object>(this.toArray());
    }

    public boolean contentEquals(Object[] array) {
        return this.contentEquals(array, 0, array.length);
    }

    public boolean contentEquals(Object[] array, int start, int end) {
        Preconditions.checkPositionIndexes((int)start, (int)end, (int)array.length);
        int alength = end - start;
        if (alength != this.length) {
            return false;
        }
        int i = this.start;
        for (int j = start; j < end; ++j) {
            if (!Objects.equals(this.contents[i], array[j])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean contentDeepEquals(Object[] array) {
        return this.contentDeepEquals(array, 0, array.length);
    }

    public boolean contentDeepEquals(Object[] array, int start, int end) {
        Preconditions.checkPositionIndexes((int)start, (int)end, (int)array.length);
        int alength = end - start;
        if (alength != this.length) {
            return false;
        }
        int i = this.start;
        for (int j = start; j < end; ++j) {
            if (!Objects.deepEquals(this.contents[i], array[j])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public boolean contains(Object o) {
        int end = this.end();
        for (int i = this.start; i < end; ++i) {
            if (!Objects.equals(o, this.contents[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.length];
        System.arraycopy(this.contents, this.start, result, 0, this.length);
        return result;
    }

    @Override
    public <U> U[] toArray(U[] a) {
        U[] targetArray = a.length < this.length ? Arrays.copyOf(a, this.length) : a;
        System.arraycopy(this.contents, this.start, targetArray, 0, this.length);
        return targetArray;
    }

    @Override
    @Deprecated
    public boolean add(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        int end = this.end();
        block0: for (Object o : c) {
            for (int i = this.start; i < end; ++i) {
                if (Objects.equals(o, this.contents[i])) continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sort(Comparator<? super T> cmp) {
        Arrays.sort(this.contents, this.start, this.end(), cmp);
    }

    public void sort() {
        Arrays.sort(this.contents, this.start, this.end());
    }

    public void sort(int startInclusive, int endExclusive, Comparator<? super T> cmp) {
        Preconditions.checkPositionIndexes((int)startInclusive, (int)endExclusive, (int)this.length);
        Arrays.sort(this.contents, this.start + startInclusive, this.start + endExclusive, cmp);
    }

    public void sort(int startInclusive, int endExclusive) {
        Preconditions.checkPositionIndexes((int)startInclusive, (int)endExclusive, (int)this.length);
        Arrays.sort(this.contents, this.start + startInclusive, this.start + endExclusive);
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T get(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.length);
        return this.contents[this.start + index];
    }

    @Override
    public T set(int index, T element) {
        Preconditions.checkElementIndex((int)index, (int)this.length);
        int effIndex = this.start + index;
        T old = this.contents[effIndex];
        this.contents[effIndex] = element;
        return old;
    }

    @Override
    public int indexOf(Object o) {
        int end = this.end();
        for (int i = this.start; i < end; ++i) {
            if (!Objects.equals(o, this.contents[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.end() - 1; i >= this.start; --i) {
            if (!Objects.equals(o, this.contents[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ArrayIterator<T>(this.contents, this.start, this.end());
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        Preconditions.checkPositionIndex((int)index, (int)this.length);
        return new ArrayIterator<T>(this.contents, this.start + index, this.end());
    }

    @Override
    @Deprecated
    public RichArray<T> subList(int fromIndex, int toIndex) {
        return this.slice(fromIndex, toIndex);
    }

    public RichArray<T> slice(int fromIndex, int toIndex) {
        Preconditions.checkPositionIndexes((int)fromIndex, (int)toIndex, (int)this.length);
        return new RichArray<T>(this.contents, this.start + fromIndex, this.start + toIndex);
    }

    @Override
    public Spliterator<T> spliterator() {
        return Arrays.spliterator(this.contents, this.start, this.end());
    }

    public Spliterator<T> spliterator(int startInclusive, int endExclusive) {
        Preconditions.checkPositionIndexes((int)startInclusive, (int)endExclusive, (int)this.length);
        return Arrays.spliterator(this.contents, this.start + startInclusive, this.start + endExclusive);
    }

    public void update(int index, T element) {
        Preconditions.checkElementIndex((int)index, (int)this.length);
        this.contents[this.start + index] = element;
    }

    public RichArray<T> copyFrom(T[] source, int sourceOfs, int destOfs, int len) {
        Preconditions.checkPositionIndexes((int)destOfs, (int)(destOfs + len), (int)this.length);
        System.arraycopy(source, sourceOfs, this.contents, this.start + destOfs, len);
        return this;
    }

    public RichArray<T> copyInto(int sourceOfs, Object[] dest, int destOfs, int len) {
        Preconditions.checkPositionIndexes((int)sourceOfs, (int)(sourceOfs + len), (int)this.length);
        System.arraycopy(this.contents, this.start + sourceOfs, dest, destOfs, len);
        return this;
    }

    public void parallelSort(Comparator<? super T> cmp) {
        Arrays.parallelSort(this.contents, this.start, this.end(), cmp);
    }

    public void parallelSort() {
        Arrays.parallelSort(this.contents, this.start, this.end(), (x, y) -> ((Comparable)x).compareTo(y));
    }

    public void parallelSort(int startInclusive, int endExclusive, Comparator<? super T> cmp) {
        Preconditions.checkPositionIndexes((int)startInclusive, (int)endExclusive, (int)this.length);
        Arrays.parallelSort(this.contents, this.start + startInclusive, this.start + endExclusive, cmp);
    }

    public void parallelSort(int startInclusive, int endExclusive) {
        Preconditions.checkPositionIndexes((int)startInclusive, (int)endExclusive, (int)this.length);
        Arrays.parallelSort(this.contents, this.start + startInclusive, this.start + endExclusive, (x, y) -> ((Comparable)x).compareTo(y));
    }

    public void parallelPrefix(BinaryOperator<T> op) {
        Arrays.parallelPrefix(this.contents, this.start, this.end(), op);
    }

    public void parallelPrefix(int startInclusive, int endExclusive, BinaryOperator<T> op) {
        Preconditions.checkPositionIndexes((int)startInclusive, (int)endExclusive, (int)this.length);
        Arrays.parallelPrefix(this.contents, this.start + startInclusive, this.start + endExclusive, op);
    }

    public int binarySearch(T key, Comparator<? super T> cmp) {
        int result = Arrays.binarySearch(this.contents, this.start, this.end(), key, cmp);
        if (result != -1) {
            result -= this.start;
        }
        return result;
    }

    public int binarySearch(int startInclusive, int endExclusive, T key, Comparator<? super T> cmp) {
        Preconditions.checkPositionIndexes((int)startInclusive, (int)endExclusive, (int)this.length);
        int result = Arrays.binarySearch(this.contents, this.start + startInclusive, this.start + endExclusive, key, cmp);
        if (result != -1) {
            result -= this.start;
        }
        return result;
    }

    public void parallelSetAll(IntFunction<? extends T> generator) {
        Objects.requireNonNull(generator);
        IntStream.range(this.start, this.end()).parallel().forEach((int i) -> {
            this.contents[i] = generator.apply(i - this.start);
        });
    }

    public void parallelSetAll(int startInclusive, int endExclusive, IntFunction<? extends T> generator) {
        Preconditions.checkPositionIndexes((int)startInclusive, (int)endExclusive, (int)this.length);
        Objects.requireNonNull(generator);
        IntStream.range(this.start + startInclusive, this.start + endExclusive).parallel().forEach((int i) -> {
            this.contents[i] = generator.apply(i - this.start);
        });
    }

    public void parallelSetAll(T value) {
        IntStream.range(this.start, this.end()).parallel().forEach((int i) -> {
            this.contents[i] = value;
        });
    }

    public void parallelSetAll(int startInclusive, int endExclusive, T value) {
        Preconditions.checkPositionIndexes((int)startInclusive, (int)endExclusive, (int)this.length);
        IntStream.range(this.start + startInclusive, this.start + endExclusive).parallel().forEach((int i) -> {
            this.contents[i] = value;
        });
    }

    public void parallelSetAll(Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier);
        IntStream.range(this.start, this.end()).parallel().forEach((int i) -> {
            this.contents[i] = supplier.get();
        });
    }

    public void parallelSetAll(int startInclusive, int endExclusive, Supplier<? extends T> supplier) {
        Preconditions.checkPositionIndexes((int)startInclusive, (int)endExclusive, (int)this.length);
        Objects.requireNonNull(supplier);
        IntStream.range(this.start + startInclusive, this.start + endExclusive).parallel().forEach((int i) -> {
            this.contents[i] = supplier.get();
        });
    }

    public void swap(int i, int j) {
        Preconditions.checkElementIndex((int)i, (int)this.length);
        Preconditions.checkElementIndex((int)j, (int)this.length);
        RichArray.doSwap(this.contents, this.start + i, this.start + j);
    }

    private static <T> void doSwap(T[] array, int i, int j) {
        T tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }

    public void shuffle() {
        this.shuffle(new Random());
    }

    public void shuffle(Random r) {
        for (int i = this.end(); i > this.start; ++i) {
            RichArray.doSwap(this.contents, i - 1, this.start + r.nextInt(i - this.start));
        }
    }

    public void reverse() {
        int i = this.start;
        for (int j = this.end() - 1; i < j; ++i, --j) {
            RichArray.doSwap(this.contents, i, j);
        }
    }

    public T min() {
        int minIdx = this.minIndex();
        return this.contents[this.start + minIdx];
    }

    public T min(Comparator<? super T> cmp) {
        int minIdx = this.minIndex(cmp);
        return this.contents[this.start + minIdx];
    }

    public int minIndex() {
        return this.minIndex((a, b) -> ((Comparable)a).compareTo(b));
    }

    public int minIndex(Comparator<? super T> cmp) {
        Objects.requireNonNull(cmp);
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        T best = this.contents[this.start];
        int bestIdx = this.start;
        int end = this.end();
        for (int i = this.start + 1; i < end; ++i) {
            T curr = this.contents[i];
            if (cmp.compare(curr, best) >= 0) continue;
            best = curr;
            bestIdx = i;
        }
        return bestIdx - this.start;
    }

    public T max() {
        int maxIdx = this.maxIndex();
        return this.contents[this.start + maxIdx];
    }

    public T max(Comparator<? super T> cmp) {
        int maxIdx = this.maxIndex(cmp);
        return this.contents[this.start + maxIdx];
    }

    public int maxIndex() {
        return this.maxIndex((a, b) -> ((Comparable)a).compareTo(b));
    }

    public int maxIndex(Comparator<? super T> cmp) {
        Objects.requireNonNull(cmp);
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        T best = this.contents[this.start];
        int bestIdx = this.start;
        int end = this.end();
        for (int i = this.start + 1; i < end; ++i) {
            T curr = this.contents[i];
            if (cmp.compare(curr, best) <= 0) continue;
            best = curr;
            bestIdx = i;
        }
        return bestIdx - this.start;
    }

    public void transformSingle(int index, Function<? super T, ? extends T> transformer) {
        Preconditions.checkElementIndex((int)index, (int)this.length);
        Objects.requireNonNull(transformer);
        int effIdx = this.start + index;
        T elem = this.contents[effIdx];
        this.contents[effIdx] = transformer.apply(elem);
    }

    public void transform(Function<? super T, ? extends T> transformer) {
        Objects.requireNonNull(transformer);
        int end = this.end();
        for (int i = this.start; i < end; ++i) {
            this.contents[i] = transformer.apply(this.contents[i]);
        }
    }

    public void transform(int startInclusive, int endExclusive, Function<? super T, ? extends T> transformer) {
        Preconditions.checkPositionIndexes((int)startInclusive, (int)endExclusive, (int)this.length);
        Objects.requireNonNull(transformer);
        int end = this.start + endExclusive;
        for (int i = this.start + startInclusive; i < end; ++i) {
            this.contents[i] = transformer.apply(this.contents[i]);
        }
    }

    public RichArray<T> parallelTransform(Function<? super T, ? extends T> transformer) {
        Objects.requireNonNull(transformer);
        IntStream.range(this.start, this.end()).parallel().forEach((int i) -> {
            this.contents[i] = transformer.apply((T)this.contents[i]);
        });
        return this;
    }

    public RichArray<T> parallelTransform(int startInclusive, int endExclusive, Function<? super T, ? extends T> transformer) {
        Preconditions.checkPositionIndexes((int)startInclusive, (int)endExclusive, (int)this.length);
        Objects.requireNonNull(transformer);
        IntStream.range(this.start + startInclusive, this.start + endExclusive).parallel().forEach((int i) -> {
            this.contents[i] = transformer.apply((T)this.contents[i]);
        });
        return this;
    }

    public RichArray<T> transformWithIndex(WithIndexTransformer<? super T, ? extends T> transformer) {
        Objects.requireNonNull(transformer);
        IntStream.range(this.start, this.end()).forEach((int i) -> {
            this.contents[i] = transformer.apply(i - this.start, (T)this.contents[i]);
        });
        return this;
    }

    public RichArray<T> transformWithIndex(int startInclusive, int endExclusive, WithIndexTransformer<? super T, ? extends T> transformer) {
        Preconditions.checkPositionIndexes((int)startInclusive, (int)endExclusive, (int)this.length);
        Objects.requireNonNull(transformer);
        IntStream.range(this.start + startInclusive, this.start + endExclusive).forEach((int i) -> {
            this.contents[i] = transformer.apply(i - this.start, (T)this.contents[i]);
        });
        return this;
    }

    public RichArray<T> parallelTransformWithIndex(WithIndexTransformer<? super T, ? extends T> transformer) {
        Objects.requireNonNull(transformer);
        IntStream.range(this.start, this.end()).parallel().forEach((int i) -> {
            this.contents[i] = transformer.apply(i - this.start, (T)this.contents[i]);
        });
        return this;
    }

    public RichArray<T> parallelTransformWithIndex(int startInclusive, int endExclusive, WithIndexTransformer<? super T, ? extends T> transformer) {
        Preconditions.checkPositionIndexes((int)startInclusive, (int)endExclusive, (int)this.length);
        Objects.requireNonNull(transformer);
        IntStream.range(this.start + startInclusive, this.start + endExclusive).parallel().forEach((int i) -> {
            this.contents[i] = transformer.apply(i - this.start, (T)this.contents[i]);
        });
        return this;
    }

    @Override
    public T apply(int value) {
        return this.get(value);
    }
}

