/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.array;

import java.io.Serializable;

public final class ResizingObjectArray
implements Serializable {
    public static final int DEFAULT_INITIAL_CAPACITY = 10;
    public Object[] array;
    private int nextCapacityHint;

    public ResizingObjectArray() {
        this(10);
    }

    public ResizingObjectArray(int initialCapacity) {
        int capacity = initialCapacity <= 0 ? 10 : initialCapacity;
        this.array = new Object[capacity];
    }

    public void hintNextCapacity(int nextCapacityHint) {
        this.nextCapacityHint = nextCapacityHint;
    }

    public boolean ensureCapacity(int minCapacity) {
        if (minCapacity <= this.array.length) {
            return false;
        }
        int newCapacity = this.array.length * 3 / 2 + 1;
        if (newCapacity < this.nextCapacityHint) {
            newCapacity = this.nextCapacityHint;
        }
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        Object[] newArray = new Object[newCapacity];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        this.array = newArray;
        this.nextCapacityHint = 0;
        return true;
    }

    public boolean shrink(int maxCapacity) {
        if (maxCapacity >= this.array.length) {
            return false;
        }
        Object[] newArray = new Object[maxCapacity];
        System.arraycopy(this.array, 0, newArray, 0, maxCapacity);
        this.array = newArray;
        return true;
    }

    public void setAll(Object value) {
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = value;
        }
    }

    public void swap(ResizingObjectArray other) {
        Object[] arrayTmp = this.array;
        int hintTmp = this.nextCapacityHint;
        this.array = other.array;
        this.nextCapacityHint = other.nextCapacityHint;
        other.array = arrayTmp;
        other.nextCapacityHint = hintTmp;
    }
}

