/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.array;

import java.lang.reflect.Array;
import java.util.Arrays;

public class ResizingArrayStorage<T> {
    public static final int DEFAULT_INITIAL_CAPACITY = 10;
    private final Class<T[]> arrayClazz;
    public T[] array;
    private int nextCapacityHint;

    public ResizingArrayStorage(Class<T[]> arrayClazz) {
        this(arrayClazz, 10);
    }

    public ResizingArrayStorage(Class<T[]> arrayClazz, int initialCapacity) {
        int capacity = initialCapacity <= 0 ? 10 : initialCapacity;
        this.array = (Object[])Array.newInstance(arrayClazz.getComponentType(), capacity);
        this.arrayClazz = arrayClazz;
    }

    public boolean ensureCapacity(int minCapacity) {
        if (minCapacity <= this.array.length) {
            return false;
        }
        int newCapacity = this.array.length * 3 / 2 + 1;
        if (newCapacity < this.nextCapacityHint) {
            newCapacity = this.nextCapacityHint;
        }
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this.array = Arrays.copyOf(this.array, newCapacity);
        this.nextCapacityHint = 0;
        return true;
    }

    public boolean shrink(int maxCapacity) {
        if (maxCapacity >= this.array.length) {
            return false;
        }
        this.array = Arrays.copyOf(this.array, maxCapacity);
        return true;
    }

    public void hintNextCapacity(int nextCapacityHint) {
        this.nextCapacityHint = nextCapacityHint;
    }

    public void setAll(T value) {
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = value;
        }
    }

    public void swap(ResizingArrayStorage<T> other) {
        if (this.arrayClazz != other.arrayClazz) {
            throw new IllegalArgumentException("Cannot swap array storages of different array classes (" + this.arrayClazz.getSimpleName() + " vs. " + other.arrayClazz.getSimpleName());
        }
        T[] arrayTmp = this.array;
        int hintTmp = this.nextCapacityHint;
        this.array = other.array;
        this.nextCapacityHint = other.nextCapacityHint;
        other.array = arrayTmp;
        other.nextCapacityHint = hintTmp;
    }
}

