/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.array;

import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ArrayIterator<T>
implements ListIterator<T> {
    private final T[] array;
    private final int start;
    private final int end;
    private int curr;

    public ArrayIterator(T[] array) {
        this(array, 0);
    }

    public ArrayIterator(T[] array, int start) {
        this(array, start, array.length);
    }

    public ArrayIterator(T[] array, int start, int end) {
        this(array, start, start, end);
    }

    public ArrayIterator(T[] array, int start, int curr, int end) {
        this.array = array;
        this.start = start;
        this.curr = curr;
        this.end = end;
    }

    @Override
    public boolean hasNext() {
        return this.curr < this.end;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.array[this.curr++];
    }

    @Override
    public boolean hasPrevious() {
        return this.curr > this.start;
    }

    @Override
    public T previous() {
        return this.array[--this.curr];
    }

    @Override
    public int nextIndex() {
        return this.curr - this.start;
    }

    @Override
    public int previousIndex() {
        return this.curr - this.start - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(T e) {
        this.array[this.curr - 1] = e;
    }

    @Override
    public void add(T e) {
        throw new UnsupportedOperationException();
    }
}

