/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOUtil.class);
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    private IOUtil() {
    }

    public static void skip(InputStream is) throws IOException {
        while (is.available() > 0) {
            is.skip(Long.MAX_VALUE);
        }
        is.close();
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        IOUtil.copy(is, os, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream is, OutputStream os, boolean close) throws IOException {
        byte[] buf = new byte[8192];
        try {
            int len;
            while ((len = is.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
        }
        finally {
            if (close) {
                IOUtil.closeQuietly(is);
                IOUtil.closeQuietly(os);
            }
        }
    }

    public static void copy(Reader r, Writer w) throws IOException {
        IOUtil.copy(r, w, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Reader r, Writer w, boolean close) throws IOException {
        char[] buf = new char[8192];
        try {
            int len;
            while ((len = r.read(buf)) != -1) {
                w.write(buf, 0, len);
            }
        }
        finally {
            if (close) {
                IOUtil.closeQuietly(r);
                IOUtil.closeQuietly(w);
            }
        }
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            LOGGER.error("Could not close closable", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream asUncompressedInputStream(InputStream is) throws IOException {
        int bytesRead;
        InputStream bufferedInputStream = IOUtil.asBufferedInputStream(is);
        assert (bufferedInputStream.markSupported());
        bufferedInputStream.mark(2);
        byte[] buf = new byte[2];
        try {
            bytesRead = bufferedInputStream.read(buf);
        }
        finally {
            bufferedInputStream.reset();
        }
        if (bytesRead == 2) {
            int byteMask = 255;
            int byteWidth = 8;
            int magic = (buf[1] & 0xFF) << 8 | buf[0] & 0xFF;
            if (magic == 35615) {
                return new GZIPInputStream(bufferedInputStream);
            }
        }
        return bufferedInputStream;
    }

    public static InputStream asBufferedInputStream(InputStream is) {
        if (is instanceof BufferedInputStream || is instanceof ByteArrayInputStream) {
            return is;
        }
        return new BufferedInputStream(is);
    }

    public static OutputStream asBufferedOutputStream(OutputStream os) {
        if (os instanceof BufferedOutputStream || os instanceof ByteArrayOutputStream) {
            return os;
        }
        return new BufferedOutputStream(os);
    }

    public static Reader asUTF8Reader(File file) throws FileNotFoundException {
        return new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
    }

    public static Writer asUTF8Writer(File file) throws FileNotFoundException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
    }
}

