/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.settings;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Properties;
import java.util.ServiceLoader;

public interface SettingsSource {
    public void loadSettings(Properties var1);

    default public int getPriority() {
        return 0;
    }

    public static <S extends SettingsSource> Properties readSettings(Class<S> clazz) {
        Properties p = new Properties();
        SettingsSource.readSettings(clazz, p);
        return p;
    }

    public static <S extends SettingsSource> void readSettings(Class<S> clazz, Properties p) {
        ServiceLoader<S> loader = ServiceLoader.load(clazz);
        ArrayList<SettingsSource> sources = new ArrayList<SettingsSource>();
        Iterators.addAll(sources, loader.iterator());
        sources.sort(new Comparator<SettingsSource>(){

            @Override
            public int compare(SettingsSource a, SettingsSource b) {
                return a.getPriority() - b.getPriority();
            }
        });
        for (SettingsSource source : sources) {
            source.loadSettings(p);
        }
    }
}

