/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.combinatorics;

public class DisjointSetForestInt {
    private int[] parent;
    private int[] rank;

    public DisjointSetForestInt(int initSize) {
        this.parent = new int[initSize];
        for (int i = 0; i < this.parent.length; ++i) {
            this.parent[i] = -1;
        }
        this.rank = new int[initSize];
    }

    public int find(int a) {
        int p = this.parent[a];
        if (p == -1) {
            return a;
        }
        this.parent[a] = p = this.find(p);
        return p;
    }

    public int union(int a, int b) {
        return this.directUnion(this.find(a), this.find(b));
    }

    public int directUnion(int a, int b) {
        assert (this.parent[a] == -1 && this.parent[b] == -1);
        if (a == b) {
            return a;
        }
        int ra = this.rank[a];
        int rb = this.rank[b];
        if (ra < rb) {
            this.parent[a] = b;
            return b;
        }
        if (ra == rb) {
            int n = a;
            this.rank[n] = this.rank[n] + 1;
        }
        this.parent[b] = a;
        return a;
    }

    public int size() {
        return this.parent.length;
    }
}

