/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util;

import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public class BitSetIterator
implements Iterator<Integer>,
PrimitiveIterator.OfInt {
    private final BitSet bitSet;
    private int currBitIdx;
    private int lastBitIdx;

    public BitSetIterator(BitSet bitSet) {
        this.bitSet = bitSet;
        this.currBitIdx = bitSet.nextSetBit(0);
        this.lastBitIdx = -1;
    }

    @Override
    public boolean hasNext() {
        return this.currBitIdx != -1;
    }

    @Override
    public int nextInt() {
        if (this.currBitIdx == -1) {
            throw new NoSuchElementException();
        }
        this.lastBitIdx = this.currBitIdx;
        this.currBitIdx = this.bitSet.nextSetBit(this.currBitIdx + 1);
        return this.lastBitIdx;
    }

    @Override
    public void remove() {
        if (this.lastBitIdx == -1) {
            throw new NoSuchElementException();
        }
        this.bitSet.clear(this.lastBitIdx);
    }
}

