/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.common.util.string;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.regex.Pattern;
import net.automatalib.common.util.string.Printable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringUtil.class);

    private StringUtil() {
    }

    public static String enquote(String s) {
        StringBuilder sb = new StringBuilder(s.length() + 2);
        try {
            StringUtil.enquote(s, sb);
        }
        catch (IOException e) {
            LOGGER.error("Could not enquote String", (Throwable)e);
        }
        return sb.toString();
    }

    public static void enquote(String s, Appendable a) throws IOException {
        a.append('\"');
        StringUtil.escapeQuotes(s, a);
        a.append('\"');
    }

    public static Pattern getIdentifierPattern() {
        return LazyPatternHolder.INSTANCE;
    }

    public static String enquoteIfNecessary(String s) {
        StringBuilder sb = new StringBuilder();
        try {
            StringUtil.enquoteIfNecessary(s, sb);
            return sb.toString();
        }
        catch (IOException ex) {
            throw new AssertionError("StringBuilder should not throw", ex);
        }
    }

    public static void enquoteIfNecessary(String s, Appendable a) throws IOException {
        StringUtil.enquoteIfNecessary(s, a, StringUtil.getIdentifierPattern());
    }

    public static String enquoteIfNecessary(String s, Pattern p) {
        StringBuilder sb = new StringBuilder();
        try {
            StringUtil.enquoteIfNecessary(s, sb, p);
            return sb.toString();
        }
        catch (IOException ex) {
            throw new AssertionError("StringBuilder should not throw", ex);
        }
    }

    public static void enquoteIfNecessary(String s, Appendable a, Pattern valid) throws IOException {
        if (!valid.matcher(s).matches()) {
            StringUtil.enquote(s, a);
        } else {
            a.append(s);
        }
    }

    public static void enquoteIfNecessary(String s, Appendable a, Pattern valid, Pattern exception) throws IOException {
        if (!valid.matcher(s).matches() || exception.matcher(s).matches()) {
            StringUtil.enquote(s, a);
        } else {
            a.append(s);
        }
    }

    public static String unquote(String s) {
        if (s.length() < 2) {
            throw new IllegalArgumentException("Argument to StringUtil.unquote() must begin and end with a double quote ('\"').");
        }
        StringBuilder sb = new StringBuilder(s.length() - 2);
        try {
            StringUtil.unquote(s, sb);
        }
        catch (IOException e) {
            LOGGER.error("Could not unquote String", (Throwable)e);
        }
        return sb.toString();
    }

    public static void unquote(String s, Appendable a) throws IOException {
        if (s.charAt(0) != '\"' || s.charAt(s.length() - 1) != '\"') {
            throw new IllegalArgumentException("Argument to StringUtil.unquote() must begin and end with a double quote ('\"').");
        }
        StringUtil.unescapeQuotes(s.substring(1, s.length() - 1), a);
    }

    public static String unescapeQuotes(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        try {
            StringUtil.unescapeQuotes(s, sb);
        }
        catch (IOException e) {
            LOGGER.error("Could not unescape quotes", (Throwable)e);
        }
        return sb.toString();
    }

    public static void unescapeQuotes(String s, Appendable a) throws IOException {
        int idx;
        if (s.isEmpty()) {
            return;
        }
        int eos = s.length() - 1;
        for (idx = 0; idx < eos; ++idx) {
            char c = s.charAt(idx);
            if (c == '\\' && (c = s.charAt(++idx)) != '\"' && c != '\\') {
                a.append('\\');
            }
            a.append(c);
        }
        if (idx < s.length()) {
            a.append(s.charAt(eos));
        }
    }

    public static String escapeQuotes(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        try {
            StringUtil.escapeQuotes(s, sb);
        }
        catch (IOException e) {
            LOGGER.error("Could not escape quotes", (Throwable)e);
        }
        return sb.toString();
    }

    public static void escapeQuotes(String s, Appendable a) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\"') {
                a.append('\\');
            }
            a.append(c);
        }
    }

    public static void appendArray(Appendable a, Object[] array, String sepString) throws IOException {
        StringUtil.appendIterable(a, () -> Iterators.forArray((Object[])array), sepString);
    }

    public static void appendArrayEnquoted(Appendable a, Object[] array, String sepString) throws IOException {
        StringUtil.appendIterableEnquoted(a, () -> Iterators.forArray((Object[])array), sepString);
    }

    public static void appendIterable(Appendable a, Iterable<?> it, String sepString) throws IOException {
        boolean first = true;
        for (Object o : it) {
            if (first) {
                first = false;
            } else {
                a.append(sepString);
            }
            StringUtil.appendObject(a, o);
        }
    }

    public static void appendIterableEnquoted(Appendable a, Iterable<?> it, String sepString) throws IOException {
        boolean first = true;
        for (Object o : it) {
            if (first) {
                first = false;
            } else {
                a.append(sepString);
            }
            StringUtil.enquote(String.valueOf(o), a);
        }
    }

    public static void appendObject(Appendable a, @Nullable Object obj) throws IOException {
        if (obj instanceof Printable) {
            ((Printable)obj).print(a);
        } else {
            a.append(String.valueOf(obj));
        }
    }

    private static class LazyPatternHolder {
        private static final Pattern INSTANCE = Pattern.compile("[a-zA-Z_]*\\w*");

        private LazyPatternHolder() {
        }
    }
}

