/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.common.util.setting;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import net.automatalib.common.util.IOUtil;
import net.automatalib.common.util.setting.SettingsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClassPathFileSource
implements SettingsSource {
    private final String fileName;

    protected AbstractClassPathFileSource(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void loadSettings(Properties properties) {
        Logger log = LoggerFactory.getLogger(this.getClass());
        try {
            Enumeration<URL> resourceUrls;
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            if (ccl == null) {
                ClassLoader scl = ClassLoader.getSystemClassLoader();
                if (scl == null) {
                    log.error("Couldn't find classloader, aborting reading '{}'", (Object)this.fileName);
                    return;
                }
                resourceUrls = scl.getResources(this.fileName);
            } else {
                resourceUrls = ccl.getResources(this.fileName);
            }
            while (resourceUrls.hasMoreElements()) {
                URL url = resourceUrls.nextElement();
                try {
                    Reader r = IOUtil.asBufferedUTF8Reader(url.openStream());
                    try {
                        properties.load(r);
                    }
                    finally {
                        if (r == null) continue;
                        r.close();
                    }
                }
                catch (IOException ex) {
                    log.error("Could not read property file " + url + ".", (Throwable)ex);
                }
            }
        }
        catch (IOException ex) {
            log.error("Could not enumerate " + this.fileName + " files,", (Throwable)ex);
        }
    }
}

