/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.common.util.collection;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ReusableIterator<T>
implements Iterable<T> {
    private final Iterator<T> iterator;
    private final List<T> cache;
    private int frontier;

    public ReusableIterator(Iterator<T> iterator) {
        this(iterator, new ArrayList());
    }

    public ReusableIterator(Iterator<T> iterator, List<T> cache) {
        this.iterator = iterator;
        this.cache = cache;
    }

    @Override
    public Iterator<T> iterator() {
        return new CopyOnReadIterator(this.iterator);
    }

    private class CopyOnReadIterator
    extends AbstractIterator<T> {
        private final Iterator<T> source;
        private int pos;

        CopyOnReadIterator(Iterator<T> source) {
            this.source = source;
        }

        protected T computeNext() {
            if (this.pos < ReusableIterator.this.frontier) {
                return ReusableIterator.this.cache.get(this.pos++);
            }
            if (!this.source.hasNext()) {
                return this.endOfData();
            }
            Object next = this.source.next();
            ReusableIterator.this.cache.add(next);
            ++this.pos;
            ReusableIterator.this.frontier++;
            return next;
        }
    }
}

