/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.common.util.collection;

import java.util.AbstractList;
import java.util.RandomAccess;
import net.automatalib.common.smartcollection.ArrayWritable;
import net.automatalib.common.util.collection.CharRangeIterator;
import net.automatalib.common.util.collection.IntRange;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CharRange
extends AbstractList<Character>
implements ArrayWritable<Character>,
RandomAccess {
    private final IntRange delegate;

    public CharRange(char low, char high) {
        this(low, high, 1);
    }

    public CharRange(char low, char high, int step) {
        this(new IntRange(low, high, step));
    }

    public CharRange(IntRange delegate) {
        this.delegate = delegate;
    }

    @Override
    public Character get(int index) {
        return Character.valueOf(this.charGet(index));
    }

    public char charGet(int index) {
        return (char)this.delegate.intGet(index);
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(@Nullable Object o) {
        if (o == null || o.getClass() != Character.class) {
            return -1;
        }
        return this.indexOf(((Character)o).charValue());
    }

    public int indexOf(char c) {
        return this.delegate.indexOf(c);
    }

    @Override
    public int lastIndexOf(@Nullable Object o) {
        return this.indexOf(o);
    }

    public CharRangeIterator iterator() {
        return new CharRangeIterator(this.delegate.iterator());
    }

    public CharRangeIterator listIterator() {
        return new CharRangeIterator(this.delegate.listIterator());
    }

    public CharRangeIterator listIterator(int index) {
        return new CharRangeIterator(this.delegate.listIterator(index));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    public void writeToArray(int offset, @Nullable Object[] array, int tgtOfs, int num) {
        int si = offset;
        int ti = tgtOfs;
        for (int i = 0; i < num; ++i) {
            array[ti++] = Character.valueOf(this.charGet(si++));
        }
    }
}

