/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.random;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RandomUtil {
    private final Random random;

    public RandomUtil() {
        this(new Random());
    }

    public RandomUtil(Random random) {
        this.random = random;
    }

    public <T> @Nullable T choose(T[] array) {
        return RandomUtil.choose(array, this.random);
    }

    public static <T> @Nullable T choose(T[] array, Random rand) {
        int len = array.length;
        if (len == 0) {
            return null;
        }
        int idx = rand.nextInt(array.length);
        return array[idx];
    }

    public <T> @Nullable T choose(List<? extends T> list) {
        return RandomUtil.choose(list, this.random);
    }

    public static <T> @Nullable T choose(List<? extends T> list, Random rand) {
        int size = list.size();
        if (size == 0) {
            return null;
        }
        int idx = rand.nextInt(size);
        return list.get(idx);
    }

    public Random getRandom() {
        return this.random;
    }

    public int[] distinctIntegers(int num, int min, int max) {
        return RandomUtil.distinctIntegers(num, min, max, this.random);
    }

    public static int[] distinctIntegers(int num, int min, int max, Random rand) {
        int range = max - min;
        int size = Math.min(num, range);
        int[] result = new int[size];
        BitSet cache = new BitSet(range);
        int idx = 0;
        for (int j = range - size; j < range; ++j) {
            int t = rand.nextInt(j + 1);
            int elem = cache.get(t) ? j : t;
            cache.set(elem);
            result[idx++] = elem + min;
        }
        return result;
    }

    public int[] distinctIntegers(int num, int max) {
        return RandomUtil.distinctIntegers(num, max, this.random);
    }

    public static int[] distinctIntegers(int num, int max, Random rand) {
        return RandomUtil.distinctIntegers(num, 0, max, rand);
    }

    public <T> List<T> sample(List<? extends T> list, int num) {
        return RandomUtil.sample(list, num, this.random);
    }

    public static <T> List<T> sample(List<? extends T> list, int num, Random rand) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>(num);
        int size = list.size();
        for (int i = 0; i < num; ++i) {
            int idx = rand.nextInt(size);
            result.add(list.get(idx));
        }
        return result;
    }

    public <T> List<T> sampleUnique(List<? extends T> list, int num) {
        return RandomUtil.sampleUnique(list, num, this.random);
    }

    public static <T> List<T> sampleUnique(List<? extends T> list, int num, Random rand) {
        int elems = list.size();
        if (elems == 0) {
            return Collections.emptyList();
        }
        int[] indices = RandomUtil.distinctIntegers(num, elems, rand);
        ArrayList<T> result = new ArrayList<T>(indices.length);
        for (int index : indices) {
            result.add(list.get(index));
        }
        return result;
    }
}

