/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.process;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.function.Consumer;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.commons.util.process.InputStreamConsumer;
import net.automatalib.commons.util.process.StreamGobbler;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ProcessUtil {
    private ProcessUtil() {
        throw new AssertionError();
    }

    public static int invokeProcess(String[] commandLine) throws IOException, InterruptedException {
        return ProcessUtil.invokeProcess(commandLine, null, (InputStreamConsumer)new InputStreamConsumer.NOPConsumer());
    }

    public static int invokeProcess(List<String> commandLine) throws IOException, InterruptedException {
        return ProcessUtil.invokeProcess(commandLine, null, (InputStreamConsumer)new InputStreamConsumer.NOPConsumer());
    }

    public static int invokeProcess(String[] commandLine, Reader input) throws IOException, InterruptedException {
        return ProcessUtil.invokeProcess(commandLine, input, (InputStreamConsumer)new InputStreamConsumer.NOPConsumer());
    }

    public static int invokeProcess(List<String> commandLine, Reader input) throws IOException, InterruptedException {
        return ProcessUtil.invokeProcess(commandLine, input, (InputStreamConsumer)new InputStreamConsumer.NOPConsumer());
    }

    public static int invokeProcess(String[] commandLine, Consumer<String> consumer) throws IOException, InterruptedException {
        return ProcessUtil.invokeProcess(commandLine, null, (InputStreamConsumer)new InputStreamConsumer.DelegatingConsumer(consumer));
    }

    public static int invokeProcess(List<String> commandLine, Consumer<String> consumer) throws IOException, InterruptedException {
        return ProcessUtil.invokeProcess(commandLine, null, (InputStreamConsumer)new InputStreamConsumer.DelegatingConsumer(consumer));
    }

    public static int invokeProcess(String[] commandLine, Reader input, Consumer<String> consumer) throws IOException, InterruptedException {
        return ProcessUtil.invokeProcess(commandLine, input, (InputStreamConsumer)new InputStreamConsumer.DelegatingConsumer(consumer));
    }

    public static int invokeProcess(List<String> commandLine, Reader input, Consumer<String> consumer) throws IOException, InterruptedException {
        return ProcessUtil.invokeProcess(commandLine, input, (InputStreamConsumer)new InputStreamConsumer.DelegatingConsumer(consumer));
    }

    private static int invokeProcess(String[] commandLine, @Nullable Reader input, InputStreamConsumer consumer) throws IOException, InterruptedException {
        return ProcessUtil.invokeProcess(new ProcessBuilder(commandLine), input, consumer);
    }

    private static int invokeProcess(List<String> commandLine, @Nullable Reader input, InputStreamConsumer consumer) throws IOException, InterruptedException {
        return ProcessUtil.invokeProcess(new ProcessBuilder(commandLine), input, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int invokeProcess(ProcessBuilder processBuilder, @Nullable Reader input, InputStreamConsumer consumer) throws IOException, InterruptedException {
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        ProcessUtil.writeProcessInput(process, input);
        consumer.consume(process.getInputStream());
        try {
            int n = process.waitFor();
            return n;
        }
        finally {
            process.destroy();
        }
    }

    public static Process buildProcess(String[] commandLine, @Nullable Reader input, @Nullable Consumer<String> stdOutConsumer, @Nullable Consumer<String> stdErrConsumer) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        Process process = processBuilder.start();
        ProcessUtil.writeProcessInput(process, input);
        if (stdOutConsumer != null) {
            StreamGobbler stdOutThread = new StreamGobbler(process.getInputStream(), new InputStreamConsumer.DelegatingConsumer(stdOutConsumer));
            stdOutThread.start();
        }
        if (stdErrConsumer != null) {
            StreamGobbler stdErrThread = new StreamGobbler(process.getErrorStream(), new InputStreamConsumer.DelegatingConsumer(stdErrConsumer));
            stdErrThread.start();
        }
        return process;
    }

    private static void writeProcessInput(Process process, @Nullable Reader input) throws IOException {
        block24: {
            try (OutputStream processInput = process.getOutputStream();){
                if (input == null) break block24;
                try (Writer writer = IOUtil.asBufferedUTF8Writer(processInput);){
                    CharStreams.copy((Readable)input, (Appendable)writer);
                }
            }
        }
    }
}

