/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.collections;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.RandomAccess;
import net.automatalib.commons.smartcollections.ArrayWritable;
import net.automatalib.commons.util.collections.IntRangeIterator;
import org.checkerframework.checker.nullness.qual.Nullable;

final class IntRange
extends AbstractList<Integer>
implements ArrayWritable<Integer>,
RandomAccess,
Serializable {
    private final int start;
    private final int step;
    private final int size;

    IntRange(int start, int end) {
        this(start, end, 1);
    }

    IntRange(int start, int end, int step) {
        this.start = start;
        this.step = step;
        this.size = (end - start - 1) / step + 1;
    }

    @Override
    public Integer get(int index) {
        return this.intGet(index);
    }

    public int intGet(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.intValue(index);
    }

    public int intValue(int i) {
        return this.start + this.step * i;
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(@Nullable Object o) {
        if (o == null || o.getClass() != Integer.class) {
            return -1;
        }
        int i = (Integer)o;
        return this.indexOf(i);
    }

    public int indexOf(int i) {
        if (i < this.start) {
            return -1;
        }
        int aligned = i - this.start;
        if (aligned % this.step != 0) {
            return -1;
        }
        int normalized = aligned / this.step;
        if (normalized >= this.size) {
            return -1;
        }
        return normalized;
    }

    @Override
    public int lastIndexOf(@Nullable Object o) {
        return this.indexOf(o);
    }

    public IntRangeIterator iterator() {
        return new IntRangeIterator(this.start, this.step, this.size);
    }

    public IntRangeIterator listIterator() {
        return new IntRangeIterator(this.start, this.step, this.size);
    }

    public IntRangeIterator listIterator(int index) {
        return new IntRangeIterator(this.start, this.step, this.size, index);
    }

    @Override
    public int size() {
        return this.size;
    }

    public void writeToArray(int offset, @Nullable Object[] array, int tgtOfs, int num) {
        int x = this.start + offset * this.step;
        int ti = tgtOfs;
        for (int i = 0; i < num; ++i) {
            array[ti++] = x;
            x += this.step;
        }
    }
}

