/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.collections;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.RandomAccess;
import net.automatalib.commons.smartcollections.ArrayWritable;
import net.automatalib.commons.util.collections.CharRangeIterator;
import net.automatalib.commons.util.collections.IntRange;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CharRange
extends AbstractList<Character>
implements ArrayWritable<Character>,
RandomAccess,
Serializable {
    private final IntRange delegate;

    public CharRange(char low, char high) {
        this(low, high, 1);
    }

    public CharRange(char low, char high, int step) {
        this(new IntRange(low, high, step));
    }

    public CharRange(IntRange delegate) {
        this.delegate = delegate;
    }

    @Override
    public Character get(int index) {
        return Character.valueOf(this.charGet(index));
    }

    public char charGet(int index) {
        int i = this.delegate.intGet(index);
        return (char)i;
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(@Nullable Object o) {
        if (o == null || o.getClass() != Character.class) {
            return -1;
        }
        return this.indexOf(((Character)o).charValue());
    }

    public int indexOf(char c) {
        return this.delegate.indexOf(c);
    }

    @Override
    public int lastIndexOf(@Nullable Object o) {
        return this.indexOf(o);
    }

    public CharRangeIterator iterator() {
        return new CharRangeIterator(this.delegate.iterator());
    }

    public CharRangeIterator listIterator() {
        return new CharRangeIterator(this.delegate.listIterator());
    }

    public CharRangeIterator listIterator(int index) {
        return new CharRangeIterator(this.delegate.listIterator(index));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    public void writeToArray(int offset, @Nullable Object[] array, int tgtOfs, int num) {
        int si = offset;
        int ti = tgtOfs;
        for (int i = 0; i < num; ++i) {
            array[ti++] = Character.valueOf(this.charGet(si++));
        }
    }

    public char charValue(int i) {
        return (char)this.delegate.intValue(i);
    }
}

