/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util;

import com.google.common.primitives.Primitives;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ReflectUtil {
    private ReflectUtil() {
    }

    public static <T> @Nullable Constructor<T> findConstructor(Class<T> clazz, Class<?> ... params) {
        try {
            return clazz.getConstructor(params);
        }
        catch (NoSuchMethodException e) {
            Constructor<?>[] ctors;
            for (Constructor<?> candidate : ctors = clazz.getConstructors()) {
                if (!ReflectUtil.w2pEquals(candidate.getParameterTypes(), params)) continue;
                return candidate;
            }
            return null;
        }
    }

    public static @Nullable Method findMethod(Class<?> clazz, String name, Class<?> ... params) {
        try {
            return clazz.getMethod(name, params);
        }
        catch (NoSuchMethodException e) {
            Method[] methods;
            for (Method candidate : methods = clazz.getMethods()) {
                if (!candidate.getName().equals(name) || !ReflectUtil.w2pEquals(candidate.getParameterTypes(), params)) continue;
                return candidate;
            }
            return null;
        }
    }

    public static @Nullable Method findMatchingMethod(Class<?> clazz, String name, Object ... args) {
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(name) || !ReflectUtil.isMatch(m.getParameterTypes(), args)) continue;
            return m;
        }
        return null;
    }

    public static @Nullable Method findMethodRT(Class<?> clazz, String name, @Nullable Class<?> returnType, Class<?> ... params) {
        Method m = ReflectUtil.findMethod(clazz, name, params);
        if (m == null) {
            return null;
        }
        if (returnType == null) {
            return m;
        }
        Class<?> rt = m.getReturnType();
        if (ReflectUtil.w2pEquals(rt, returnType) || returnType.isAssignableFrom(rt)) {
            return m;
        }
        return null;
    }

    private static boolean w2pEquals(Class<?>[] a, Class<?> ... b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (ReflectUtil.w2pEquals(a[i], b[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean w2pEquals(Class<?> a, Class<?> b) {
        Class wrappedA = Primitives.unwrap(a);
        Class wrappedB = Primitives.unwrap(b);
        return wrappedA.equals(wrappedB);
    }

    private static boolean isMatch(Class<?>[] paramTypes, Object ... args) {
        if (paramTypes.length != args.length) {
            return false;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> argType;
            Class<?> paramType = paramTypes[i];
            Object arg = args[i];
            if (paramType.isPrimitive()) {
                if (arg == null) {
                    return false;
                }
                argType = arg.getClass();
                if (paramType == Primitives.unwrap(argType)) continue;
                return false;
            }
            if (arg == null || paramType.isAssignableFrom(argType = arg.getClass())) continue;
            return false;
        }
        return true;
    }
}

