/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.smartcollections;

import com.google.common.collect.Iterators;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Objects;
import net.automatalib.commons.smartcollections.ElementReference;
import net.automatalib.commons.smartcollections.SmartCollection;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractSmartCollection<E>
extends AbstractCollection<E>
implements SmartCollection<E> {
    @Override
    public E choose() {
        return this.iterator().next();
    }

    @Override
    public ElementReference chooseRef() {
        return this.referenceIterator().next();
    }

    @Override
    public Iterable<ElementReference> references() {
        return this::referenceIterator;
    }

    @Override
    public void addAll(Iterable<? extends E> iterable) {
        for (E e : iterable) {
            this.add(e);
        }
    }

    @Override
    public <T extends E> void addAll(T[] array) {
        for (T t : array) {
            this.add(t);
        }
    }

    @Override
    public @Nullable ElementReference find(@Nullable Object element) {
        for (ElementReference ref : this.references()) {
            Object current = this.get(ref);
            if (!Objects.equals(current, element)) continue;
            return ref;
        }
        return null;
    }

    @Override
    public void quickClear() {
        this.clear();
    }

    @Override
    public void deepClear() {
        this.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.transform(this.referenceIterator(), this::get);
    }

    @Override
    public boolean add(E e) {
        this.referencedAdd(e);
        return true;
    }

    @Override
    public boolean remove(@Nullable Object element) {
        ElementReference ref = this.find(element);
        if (ref == null) {
            return false;
        }
        this.remove(ref);
        return true;
    }
}

