/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.smartcollections;

import java.io.Serializable;
import java.util.Arrays;
import net.automatalib.commons.smartcollections.ArrayUtil;
import net.automatalib.commons.smartcollections.CapacityManagement;

public final class ResizingIntArray
implements CapacityManagement,
Serializable {
    public static final int DEFAULT_INITIAL_CAPACITY = 10;
    public int[] array;
    private int nextCapacityHint;

    public ResizingIntArray() {
        this(10);
    }

    public ResizingIntArray(int initialCapacity) {
        int capacity = initialCapacity <= 0 ? 10 : initialCapacity;
        this.array = new int[capacity];
    }

    @Override
    public boolean ensureCapacity(int minCapacity) {
        if (minCapacity <= this.array.length) {
            return false;
        }
        int newCapacity = ArrayUtil.computeNewCapacity(this.array.length, minCapacity, this.nextCapacityHint);
        this.array = Arrays.copyOf(this.array, newCapacity);
        this.nextCapacityHint = 0;
        return true;
    }

    @Override
    public boolean ensureAdditionalCapacity(int additionalCapacity) {
        return this.ensureCapacity(this.array.length + additionalCapacity);
    }

    @Override
    public void hintNextCapacity(int nextCapacityHint) {
        this.nextCapacityHint = nextCapacityHint;
    }

    public boolean shrink(int maxCapacity) {
        if (maxCapacity >= this.array.length) {
            return false;
        }
        int[] newArray = new int[maxCapacity];
        System.arraycopy(this.array, 0, newArray, 0, maxCapacity);
        this.array = newArray;
        return true;
    }

    public void setAll(int value) {
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = value;
        }
    }

    public void swap(ResizingIntArray other) {
        int[] arrayTmp = this.array;
        int hintTmp = this.nextCapacityHint;
        this.array = other.array;
        this.nextCapacityHint = other.nextCapacityHint;
        other.array = arrayTmp;
        other.nextCapacityHint = hintTmp;
    }
}

