/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.smartcollections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import net.automatalib.commons.smartcollections.AbstractSmartCollection;
import net.automatalib.commons.smartcollections.CapacityManagement;
import net.automatalib.commons.smartcollections.ElementReference;
import net.automatalib.commons.smartcollections.InvalidReferenceException;
import net.automatalib.commons.smartcollections.ResizingArrayStorage;
import net.automatalib.commons.smartcollections.SmartDynamicPriorityQueue;

public class BinaryHeap<E>
extends AbstractSmartCollection<E>
implements SmartDynamicPriorityQueue<E>,
CapacityManagement,
Queue<E> {
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private final Comparator<? super E> comparator;
    private final ResizingArrayStorage<Reference<E>> entries;
    private int size;

    protected BinaryHeap(int initCapacity, Collection<? extends E> initValues, Comparator<? super E> comparator) {
        this(initCapacity < initValues.size() ? initValues.size() : initCapacity, comparator);
        int i = 0;
        for (E e : initValues) {
            ((Reference[])this.entries.array)[i++] = new Reference<E>(0, e);
        }
        super.buildHeap(initValues.size());
    }

    protected BinaryHeap(int initialCapacity, Comparator<? super E> comparator) {
        this.entries = new ResizingArrayStorage<Reference>(Reference.class, initialCapacity);
        this.comparator = comparator;
    }

    private void buildHeap(int numElements) {
        this.size = numElements;
        for (int i = numElements / 2; i >= 0; --i) {
            this.downHeap(i);
        }
    }

    private void downHeap(int idx) {
        Reference e = ((Reference[])this.entries.array)[idx];
        int iter = idx;
        while (this.hasChildren(iter)) {
            int rcidx;
            Reference rc;
            int cidx = BinaryHeap.leftChild(iter);
            Reference c = ((Reference[])this.entries.array)[cidx];
            if (this.hasRightChild(iter) && this.compare(rc = ((Reference[])this.entries.array)[rcidx = BinaryHeap.rightChild(iter)], c) < 0) {
                cidx = rcidx;
                c = rc;
            }
            if (this.compare(e, c) <= 0) break;
            ((Reference[])this.entries.array)[cidx] = e;
            ((Reference[])this.entries.array)[iter] = c;
            c.index = iter;
            iter = cidx;
        }
        e.index = iter;
    }

    private boolean hasChildren(int idx) {
        return idx * 2 < this.size;
    }

    private static int leftChild(int parent) {
        return 2 * parent;
    }

    private boolean hasRightChild(int idx) {
        return idx * 2 + 1 < this.size;
    }

    private static int rightChild(int parent) {
        return 2 * parent + 1;
    }

    private int compare(Reference<E> e1, Reference<E> e2) {
        return this.comparator.compare(((Reference)e1).element, ((Reference)e2).element);
    }

    public static <E extends Comparable<E>> BinaryHeap<E> create() {
        return new BinaryHeap(10, Comparator.naturalOrder());
    }

    public static <E extends Comparable<E>> BinaryHeap<E> create(int initialCapacity) {
        return new BinaryHeap(initialCapacity, Comparator.naturalOrder());
    }

    public static <E extends Comparable<E>> BinaryHeap<E> create(Collection<? extends E> initValues) {
        return new BinaryHeap<E>(0, initValues, Comparator.naturalOrder());
    }

    public static <E extends Comparable<E>> BinaryHeap<E> create(int initialCapacity, Collection<? extends E> initValues) {
        return new BinaryHeap<E>(initialCapacity, initValues, Comparator.naturalOrder());
    }

    public static <E> BinaryHeap<E> createCmp(Comparator<? super E> comparator) {
        return new BinaryHeap<E>(10, comparator);
    }

    public static <E> BinaryHeap<E> createCmp(Comparator<? super E> comparator, int initialCapacity) {
        return new BinaryHeap<E>(initialCapacity, comparator);
    }

    public static <E> BinaryHeap<E> createCmp(Comparator<? super E> comparator, Collection<? extends E> initValues) {
        return new BinaryHeap<E>(0, initValues, comparator);
    }

    public static <E> BinaryHeap<E> createCmp(Comparator<? super E> comparator, int initialCapacity, Collection<? extends E> initValues) {
        return new BinaryHeap<E>(initialCapacity, initValues, comparator);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public E get(ElementReference ref) {
        return (E)((Reference)BinaryHeap.asHeapRef(ref)).element;
    }

    private static <E> Reference<E> asHeapRef(ElementReference ref) {
        if (ref.getClass() != Reference.class) {
            throw new InvalidReferenceException("Reference is of wrong class '" + ref.getClass().getName() + "', should be " + Reference.class.getName() + ".");
        }
        return (Reference)ref;
    }

    @Override
    public Reference<E> referencedAdd(E elem) {
        Reference<E> entry;
        this.ensureCapacity(this.size + 1);
        ((Reference[])this.entries.array)[this.size] = entry = new Reference<E>(this.size, elem);
        this.upHeap(this.size++);
        return entry;
    }

    @Override
    public void remove(ElementReference ref) {
        this.remove(((Reference)BinaryHeap.asHeapRef(ref)).index);
    }

    private void remove(int index) {
        this.forceToTop(index);
        this.extractMin();
    }

    @Override
    public E remove() {
        return this.extractMin();
    }

    private void forceToTop(int idx) {
        Reference e = ((Reference[])this.entries.array)[idx];
        int iter = idx;
        while (BinaryHeap.hasParent(iter)) {
            int pidx = BinaryHeap.parent(iter);
            Reference p = ((Reference[])this.entries.array)[pidx];
            ((Reference[])this.entries.array)[pidx] = e;
            ((Reference[])this.entries.array)[iter] = p;
            p.index = iter;
            iter = BinaryHeap.parent(iter);
        }
        e.index = iter;
    }

    @Override
    public Iterator<ElementReference> referenceIterator() {
        return new ReferenceIterator();
    }

    @Override
    public void replace(ElementReference ref, E newElement) {
        Reference<E> heapRef = BinaryHeap.asHeapRef(ref);
        ((Reference)heapRef).element = newElement;
        this.keyChanged(ref);
    }

    @Override
    public void keyChanged(ElementReference ref) {
        this.keyChanged(((Reference)BinaryHeap.asHeapRef(ref)).index);
    }

    public void keyChanged(int index) {
        this.upHeap(index);
        this.downHeap(index);
    }

    @Override
    public boolean ensureCapacity(int minCapacity) {
        return this.entries.ensureCapacity(minCapacity);
    }

    private void upHeap(int idx) {
        int pidx;
        Reference p;
        Reference e = ((Reference[])this.entries.array)[idx];
        int iter = idx;
        while (BinaryHeap.hasParent(iter) && this.compare(e, p = ((Reference[])this.entries.array)[pidx = BinaryHeap.parent(iter)]) < 0) {
            ((Reference[])this.entries.array)[pidx] = e;
            ((Reference[])this.entries.array)[iter] = p;
            p.index = iter;
            iter = BinaryHeap.parent(iter);
        }
        e.index = iter;
    }

    private static boolean hasParent(int idx) {
        return idx > 0;
    }

    private static int parent(int child) {
        return child / 2;
    }

    @Override
    public boolean ensureAdditionalCapacity(int additionalCapacity) {
        return this.ensureCapacity(this.size + additionalCapacity);
    }

    @Override
    public void hintNextCapacity(int nextCapacityHint) {
        this.entries.hintNextCapacity(nextCapacityHint);
    }

    @Override
    public void quickClear() {
        this.size = 0;
    }

    @Override
    public void deepClear() {
        this.entries.setAll(null);
    }

    @Override
    public boolean offer(E e) {
        this.add(e);
        return true;
    }

    @Override
    public E poll() {
        if (this.size > 0) {
            return this.extractMin();
        }
        return null;
    }

    @Override
    public E element() {
        return this.peekMin();
    }

    @Override
    public E peekMin() {
        if (this.size <= 0) {
            throw new NoSuchElementException();
        }
        return (E)((Reference[])this.entries.array)[0].element;
    }

    @Override
    public E extractMin() {
        if (this.size <= 0) {
            throw new NoSuchElementException();
        }
        Object min = ((Reference[])this.entries.array)[0].element;
        ((Reference[])this.entries.array)[0] = ((Reference[])this.entries.array)[--this.size];
        ((Reference[])this.entries.array)[this.size] = null;
        if (this.size > 0) {
            this.downHeap(0);
        }
        return (E)min;
    }

    @Override
    public E peek() {
        if (this.size > 0) {
            return this.peekMin();
        }
        return null;
    }

    private class ReferenceIterator
    implements Iterator<ElementReference> {
        private int current;

        private ReferenceIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current < BinaryHeap.this.size;
        }

        @Override
        public ElementReference next() {
            if (this.current >= BinaryHeap.this.size) {
                throw new NoSuchElementException();
            }
            return ((Reference[])((BinaryHeap)BinaryHeap.this).entries.array)[this.current++];
        }

        @Override
        public void remove() {
            BinaryHeap.this.remove(--this.current);
        }
    }

    private static final class Reference<E>
    implements ElementReference {
        private int index;
        private E element;

        protected Reference(int index, E element) {
            this.element = element;
            this.index = index;
        }
    }
}

