/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.smartcollections;

import com.google.common.collect.Iterators;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.automatalib.commons.smartcollections.AbstractSmartCollection;
import net.automatalib.commons.smartcollections.BinaryHeap;
import net.automatalib.commons.smartcollections.ElementReference;
import net.automatalib.commons.smartcollections.SmartDynamicPriorityQueue;
import net.automatalib.commons.smartcollections.SmartGeneralPriorityQueue;

public class BackedGeneralPriorityQueue<E, K extends Comparable<K>>
extends AbstractSmartCollection<E>
implements SmartGeneralPriorityQueue<E, K> {
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private final SmartDynamicPriorityQueue<Entry<E, K>> backingQueue;
    private K defaultKey;

    public BackedGeneralPriorityQueue() {
        this(10);
    }

    public BackedGeneralPriorityQueue(int initialCapacity) {
        this.backingQueue = BinaryHeap.create(initialCapacity);
    }

    public BackedGeneralPriorityQueue(List<? extends E> init, List<K> keys) {
        ArrayList<Entry<E, Comparable>> entries = new ArrayList<Entry<E, Comparable>>(init.size());
        Iterator<E> elemIt = init.iterator();
        Iterator<K> keyIt = keys.iterator();
        while (elemIt.hasNext()) {
            Comparable key = keyIt.hasNext() ? (Comparable)keyIt.next() : null;
            entries.add(new Entry<E, Comparable>(elemIt.next(), key));
        }
        this.backingQueue = BinaryHeap.create(entries);
    }

    public BackedGeneralPriorityQueue(Class<? extends SmartDynamicPriorityQueue<?>> backingClazz) {
        SmartDynamicPriorityQueue<?> backing;
        try {
            backing = backingClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot instantiate backing priority queue of type " + backingClazz.getName() + ": " + e.getMessage(), e);
        }
        this.backingQueue = backing;
    }

    public BackedGeneralPriorityQueue(SmartDynamicPriorityQueue<?> backingQueue) {
        if (!backingQueue.isEmpty()) {
            throw new IllegalArgumentException("Backing priority queue must be empty upon initialization!");
        }
        this.backingQueue = backingQueue;
    }

    @Override
    public E choose() {
        Entry entry = (Entry)this.backingQueue.choose();
        if (entry == null) {
            return null;
        }
        return entry.element;
    }

    @Override
    public ElementReference chooseRef() {
        return this.backingQueue.chooseRef();
    }

    @Override
    public ElementReference find(Object element) {
        for (ElementReference ref : this.backingQueue.references()) {
            Entry entry = (Entry)this.backingQueue.get(ref);
            if (!Objects.equals(entry.element, element)) continue;
            return ref;
        }
        return null;
    }

    @Override
    public void quickClear() {
        this.backingQueue.quickClear();
    }

    @Override
    public void deepClear() {
        this.backingQueue.deepClear();
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.transform(this.backingQueue.iterator(), e -> e.element);
    }

    @Override
    public E get(ElementReference ref) {
        Entry entry = (Entry)this.backingQueue.get(ref);
        return entry.element;
    }

    @Override
    public ElementReference referencedAdd(E elem) {
        return this.add(elem, this.defaultKey);
    }

    @Override
    public ElementReference add(E elem, K key) {
        Entry<E, K> entry = new Entry<E, K>(elem, key);
        return this.backingQueue.referencedAdd(entry);
    }

    @Override
    public void setDefaultKey(K defaultKey) {
        this.defaultKey = defaultKey;
    }

    @Override
    public void changeKey(ElementReference ref, K newKey) {
        Entry entry = (Entry)this.backingQueue.get(ref);
        entry.key = newKey;
        this.backingQueue.keyChanged(ref);
    }

    @Override
    public void remove(ElementReference ref) {
        this.backingQueue.remove(ref);
    }

    @Override
    public Iterator<ElementReference> referenceIterator() {
        return this.backingQueue.referenceIterator();
    }

    @Override
    public void replace(ElementReference ref, E newElement) {
        Entry entry = (Entry)this.backingQueue.get(ref);
        entry.element = newElement;
    }

    @Override
    public int size() {
        return this.backingQueue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingQueue.isEmpty();
    }

    @Override
    public void clear() {
        this.backingQueue.clear();
    }

    @Override
    public E peekMin() {
        Entry min = (Entry)this.backingQueue.peekMin();
        return min.element;
    }

    @Override
    public E extractMin() {
        Entry min = (Entry)this.backingQueue.extractMin();
        return min.element;
    }

    private static class Entry<E, K extends Comparable<K>>
    implements Comparable<Entry<E, K>> {
        public E element;
        public K key;

        Entry(E element, K key) {
            this.element = element;
            this.key = key;
        }

        @Override
        public int compareTo(Entry<E, K> o) {
            return this.key.compareTo(o.key);
        }
    }
}

