/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.smartcollections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.automatalib.commons.smartcollections.AbstractSmartCollection;
import net.automatalib.commons.smartcollections.ElementReference;
import net.automatalib.commons.smartcollections.LinkedListEntry;
import net.automatalib.commons.smartcollections.SmartSequence;

public abstract class AbstractLinkedList<E, T extends LinkedListEntry<E, T>>
extends AbstractSmartCollection<E>
implements SmartSequence<E> {
    private T head;
    private T last;
    private int size;

    protected void pushFrontEntry(T e) {
        e.setPrev(null);
        e.setNext(this.head);
        if (this.head != null) {
            this.head.setPrev(e);
        } else {
            this.last = e;
        }
        this.head = e;
        ++this.size;
    }

    protected void pushBackEntry(T e) {
        e.setNext(null);
        e.setPrev(this.last);
        if (this.last != null) {
            this.last.setNext(e);
        } else {
            this.head = e;
        }
        this.last = e;
        ++this.size;
    }

    protected T getFrontEntry() {
        return this.head;
    }

    protected T getBackEntry() {
        return this.last;
    }

    protected T popFrontEntry() {
        if (this.head == null) {
            return null;
        }
        Object next = this.head.getNext();
        if (next != null) {
            next.setPrev(null);
        } else {
            this.last = null;
        }
        Object e = this.head;
        this.head = next;
        e.setNext(null);
        --this.size;
        return (T)e;
    }

    protected T popBackEntry() {
        if (this.last == null) {
            return null;
        }
        Object prev = this.last.getPrev();
        if (prev != null) {
            prev.setNext(null);
        } else {
            this.head = null;
        }
        Object e = this.last;
        this.last = prev;
        e.setPrev(null);
        --this.size;
        return (T)e;
    }

    protected void insertBeforeEntry(T e, T insertPos) {
        T oldPrev = insertPos.getPrev();
        e.setNext(insertPos);
        e.setPrev(oldPrev);
        insertPos.setPrev(e);
        if (oldPrev != null) {
            oldPrev.setNext(e);
        } else {
            this.head = e;
        }
        ++this.size;
    }

    protected void insertAfterEntry(T e, T insertPos) {
        T oldNext = insertPos.getNext();
        e.setNext(oldNext);
        e.setPrev(insertPos);
        insertPos.setNext(e);
        if (oldNext != null) {
            oldNext.setPrev(e);
        } else {
            this.last = e;
        }
        ++this.size;
    }

    protected void removeEntry(T entry) {
        Object prev = entry.getPrev();
        Object next = entry.getNext();
        if (prev != null) {
            prev.setNext(next);
        } else {
            this.head = next;
        }
        if (next != null) {
            next.setPrev(prev);
        } else {
            this.last = prev;
        }
        --this.size;
    }

    protected void replaceEntry(T oldEntry, T newEntry) {
        T prev = oldEntry.getPrev();
        T next = newEntry.getNext();
        if (prev != null) {
            prev.setNext(newEntry);
        } else {
            this.head = newEntry;
        }
        if (next != null) {
            next.setPrev(newEntry);
        } else {
            this.last = newEntry;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public void clear() {
        this.last = null;
        this.head = null;
        this.size = 0;
    }

    @Deprecated
    public void addCompletely(AbstractLinkedList<? extends E, ? extends T> other) {
        this.concat(other);
    }

    public void concat(AbstractLinkedList<? extends E, ? extends T> other) {
        if (other.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            this.head = other.head;
            this.last = other.last;
        } else {
            this.last.setNext(other.head);
            other.head.setPrev(this.last);
            this.last = other.last;
        }
        this.size += other.size;
        other.clear();
    }

    @Override
    public E choose() {
        if (this.head == null) {
            throw new NoSuchElementException();
        }
        return this.head.getElement();
    }

    @Override
    public ElementReference chooseRef() {
        return this.head;
    }

    @Override
    public E get(ElementReference ref) {
        return ((LinkedListEntry)ref).getElement();
    }

    @Override
    public Iterator<ElementReference> referenceIterator() {
        return new LinkedListEntryIterator(this, this.head);
    }

    @Override
    public Iterator<E> iterator() {
        return new ElementIterator(this, this.head);
    }

    @Override
    public ElementReference referencedAdd(E elem) {
        T entry = this.makeEntry(elem);
        this.pushBackEntry(entry);
        return entry;
    }

    @Override
    public void remove(ElementReference elem) {
        this.removeEntry((LinkedListEntry)elem);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void replace(ElementReference ref, E newElement) {
        T newEntry = this.makeEntry(newElement);
        this.replaceEntry((LinkedListEntry)ref, newEntry);
    }

    public E getBack() {
        if (this.last == null) {
            throw new NoSuchElementException();
        }
        return this.last.getElement();
    }

    public ElementReference getBackReference() {
        return this.last;
    }

    public E getFront() {
        if (this.head == null) {
            throw new NoSuchElementException();
        }
        return this.head.getElement();
    }

    public ElementReference getFrontReference() {
        return this.head;
    }

    @Override
    public ElementReference insertAfter(E element, ElementReference ref) {
        T entry = this.makeEntry(element);
        this.insertAfterEntry(entry, (LinkedListEntry)ref);
        return entry;
    }

    @Override
    public ElementReference insertBefore(E element, ElementReference ref) {
        T entry = this.makeEntry(element);
        this.insertBeforeEntry(entry, (LinkedListEntry)ref);
        return entry;
    }

    public E popBack() {
        return this.popBackEntry().getElement();
    }

    public E popFront() {
        return this.popFrontEntry().getElement();
    }

    public ElementReference pushBack(E element) {
        T entry = this.makeEntry(element);
        this.pushBackEntry(entry);
        return entry;
    }

    public ElementReference pushFront(E element) {
        T entry = this.makeEntry(element);
        this.pushFrontEntry(entry);
        return entry;
    }

    protected abstract T makeEntry(E var1);

    protected T castRef(ElementReference ref) {
        return (T)((LinkedListEntry)ref);
    }

    @Override
    public ElementReference pred(ElementReference ref) {
        return this.castRef(ref).getPrev();
    }

    @Override
    public ElementReference succ(ElementReference ref) {
        return this.castRef(ref).getNext();
    }

    public void swap(AbstractLinkedList<E, T> other) {
        int sizeTmp = this.size;
        T headTmp = this.head;
        T lastTmp = this.last;
        this.size = other.size;
        this.head = other.head;
        this.last = other.last;
        other.size = sizeTmp;
        other.head = headTmp;
        other.last = lastTmp;
    }

    private static class ElementIterator
    implements Iterator<E> {
        private T current;
        final /* synthetic */ AbstractLinkedList this$0;

        public ElementIterator(T head) {
            this.this$0 = var1_1;
            this.current = head;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public E next() {
            Object e = this.current.getElement();
            this.current = this.current.getNext();
            return e;
        }

        @Override
        public void remove() {
            Object next = this.current.getNext();
            this.this$0.removeEntry(this.current);
            this.current = next;
        }
    }

    private static class LinkedListEntryIterator
    implements Iterator<T> {
        private T current;
        final /* synthetic */ AbstractLinkedList this$0;

        public LinkedListEntryIterator(T head) {
            this.this$0 = var1_1;
            this.current = head;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public T next() {
            Object e = this.current;
            this.current = this.current.getNext();
            return e;
        }

        @Override
        public void remove() {
            Object next = this.current.getNext();
            this.this$0.removeEntry(this.current);
            this.current = next;
        }
    }
}

