/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.smartcollections;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import net.automatalib.commons.smartcollections.AbstractSmartCollection;
import net.automatalib.commons.smartcollections.CapacityManagement;
import net.automatalib.commons.smartcollections.ElementReference;
import net.automatalib.commons.smartcollections.InvalidReferenceException;
import net.automatalib.commons.util.array.ResizingObjectArray;

public class UnorderedCollection<E>
extends AbstractSmartCollection<E>
implements CapacityManagement {
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private final ResizingObjectArray storage;
    private int size;

    public UnorderedCollection() {
        this(10);
    }

    public UnorderedCollection(int initialCapacity) {
        if (initialCapacity <= 0) {
            initialCapacity = 10;
        }
        this.storage = new ResizingObjectArray(initialCapacity);
    }

    public UnorderedCollection(Collection<? extends E> coll) {
        this(coll.size());
        this.addAll(coll);
    }

    private static <E> Reference<E> asIndexedRef(ElementReference ref) {
        if (ref.getClass() != Reference.class) {
            throw new InvalidReferenceException("Reference is of wrong class '" + ref.getClass().getName() + "', should be " + Reference.class.getName() + ".");
        }
        return (Reference)ref;
    }

    private int extractValidIndex(ElementReference ref) {
        Reference<E> iRef = UnorderedCollection.asIndexedRef(ref);
        int idx = iRef.index;
        if (idx < 0 || idx >= this.size) {
            throw new InvalidReferenceException("Index " + idx + " is not valid for collection with size " + this.size + ".");
        }
        return idx;
    }

    @Override
    public E get(ElementReference ref) {
        Reference<E> r = UnorderedCollection.asIndexedRef(ref);
        return r.element;
    }

    @Override
    public ElementReference referencedAdd(E elem) {
        Reference<E> ref;
        this.ensureCapacity(this.size + 1);
        int insertPos = this.size++;
        this.storage.array[insertPos] = ref = new Reference<E>(elem, insertPos);
        return ref;
    }

    @Override
    public <T extends E> void addAll(T[] array) {
        int sizeInc = array.length;
        this.ensureCapacity(this.size + sizeInc);
        int index = this.size;
        for (int i = 0; i < array.length; ++i) {
            this.storage.array[index] = new Reference<T>(array[i], index);
            ++index;
        }
        this.size += sizeInc;
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        int sizeInc = coll.size();
        this.ensureCapacity(this.size + sizeInc);
        for (E elem : coll) {
            this.storage.array[this.size] = new Reference<E>(elem, this.size);
        }
        this.size += sizeInc;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<ElementReference> referenceIterator() {
        return new ReferenceIterator();
    }

    @Override
    public Iterable<ElementReference> references() {
        return new Iterable<ElementReference>(){

            @Override
            public Iterator<ElementReference> iterator() {
                return UnorderedCollection.this.referenceIterator();
            }
        };
    }

    private void remove(int index) {
        int lastIndex = --this.size;
        Reference removed = (Reference)this.storage.array[index];
        Reference lastElem = (Reference)this.storage.array[lastIndex];
        this.storage.array[index] = lastElem;
        lastElem.index = index;
        removed.index = -1;
        this.storage.array[lastIndex] = null;
    }

    @Override
    public void remove(ElementReference ref) {
        this.remove(this.extractValidIndex(ref));
    }

    @Override
    public boolean remove(Object elem) {
        for (int i = 0; i < this.size; ++i) {
            if (!Objects.equals(this.storage.array[i], elem)) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<E> iterator() {
        return new ElementIterator();
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            ((Reference)this.storage.array[i]).index = -1;
            this.storage.array[i] = null;
        }
        this.size = 0;
    }

    @Override
    public E choose() {
        if (this.size == 0) {
            return null;
        }
        return ((Reference)this.storage.array[0]).element;
    }

    @Override
    public ElementReference chooseRef() {
        if (this.size == 0) {
            return null;
        }
        return (ElementReference)this.storage.array[0];
    }

    @Override
    public void replace(ElementReference ref, E newElement) {
        int idx = this.extractValidIndex(ref);
        ((Reference)this.storage.array[idx]).element = newElement;
    }

    @Override
    public boolean ensureCapacity(int minCapacity) {
        return this.storage.ensureCapacity(minCapacity);
    }

    @Override
    public boolean ensureAdditionalCapacity(int additionalSpace) {
        return this.ensureCapacity(this.size + additionalSpace);
    }

    @Override
    public void hintNextCapacity(int nextCapacityHint) {
        this.storage.hintNextCapacity(nextCapacityHint);
    }

    @Override
    public void deepClear() {
        this.storage.setAll(null);
    }

    @Override
    public void quickClear() {
        this.size = 0;
    }

    public void swap(UnorderedCollection<E> other) {
        int sizeTmp = this.size;
        this.size = other.size;
        other.size = sizeTmp;
        this.storage.swap(other.storage);
    }

    private class ElementIterator
    implements Iterator<E> {
        private int index;

        private ElementIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < UnorderedCollection.this.size;
        }

        @Override
        public E next() {
            return ((Reference)((UnorderedCollection)UnorderedCollection.this).storage.array[this.index++]).element;
        }

        @Override
        public void remove() {
            UnorderedCollection.this.remove(--this.index);
        }
    }

    private class ReferenceIterator
    implements Iterator<ElementReference> {
        private int index;

        private ReferenceIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < UnorderedCollection.this.size;
        }

        @Override
        public ElementReference next() {
            return (ElementReference)((UnorderedCollection)UnorderedCollection.this).storage.array[this.index++];
        }

        @Override
        public void remove() {
            UnorderedCollection.this.remove(--this.index);
        }
    }

    private static class Reference<E>
    implements ElementReference {
        public E element;
        public int index;

        public Reference(E element, int index) {
            this.element = element;
            this.index = index;
        }
    }
}

