/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.dotutil;

import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import net.automatalib.commons.dotutil.DOTComponent;
import net.automatalib.commons.util.IOUtil;

public class DOT {
    private static final Logger LOGGER = Logger.getLogger("automatalib.dotutil");
    private static final int MAX_WIDTH = 800;
    private static final int MAX_HEIGHT = 600;
    private static String dotExe = "dot";

    public static void setDotExe(String dotExe) {
        DOT.dotExe = dotExe;
    }

    public static boolean checkUsable() {
        try {
            Process p = DOT.executeDOTRaw("-V");
            int result = p.waitFor();
            if (result == 0) {
                return true;
            }
        }
        catch (IOException | InterruptedException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static Process executeDOTRaw(String ... opts) throws IOException {
        String[] dotArgs = new String[1 + opts.length];
        dotArgs[0] = dotExe;
        System.arraycopy(opts, 0, dotArgs, 1, opts.length);
        Process dot = Runtime.getRuntime().exec(dotArgs);
        return dot;
    }

    public static Process executeDOT(String format, String ... additionalOpts) throws IOException {
        String[] dotArgs = new String[1 + additionalOpts.length];
        dotArgs[0] = "-T" + format;
        System.arraycopy(additionalOpts, 0, dotArgs, 1, additionalOpts.length);
        return DOT.executeDOTRaw(dotArgs);
    }

    public static InputStream runDOT(Reader r, String format, String ... additionalOpts) throws IOException {
        Process dot = DOT.executeDOT(format, additionalOpts);
        OutputStream dotIn = dot.getOutputStream();
        OutputStreamWriter dotWriter = new OutputStreamWriter(dotIn);
        IOUtil.copy((Reader)r, (Writer)dotWriter);
        try {
            IOUtil.skip((InputStream)dot.getErrorStream());
        }
        catch (IOException e) {
            // empty catch block
        }
        return dot.getInputStream();
    }

    public static InputStream runDOT(String dotText, String format, String ... additionalOpts) throws IOException {
        StringReader sr = new StringReader(dotText);
        return DOT.runDOT((Reader)sr, format, additionalOpts);
    }

    public static InputStream runDOT(File dotFile, String format, String ... additionalOpts) throws IOException {
        FileReader fr = new FileReader(dotFile);
        return DOT.runDOT((Reader)fr, format, additionalOpts);
    }

    public static void runDOT(Reader r, String format, File out) throws IOException {
        Process dot = DOT.executeDOT(format, "-o" + out.getAbsolutePath());
        OutputStream dotIn = dot.getOutputStream();
        OutputStreamWriter dotWriter = new OutputStreamWriter(dotIn);
        IOUtil.copy((Reader)r, (Writer)dotWriter);
        dot.getErrorStream().close();
        dot.getInputStream().close();
        try {
            dot.waitFor();
        }
        catch (InterruptedException ex) {
            LOGGER.warning("Interrupted while waiting for 'dot' process to exit." + ex);
        }
    }

    public static void runDOT(String dotText, String format, File out) throws IOException {
        DOT.runDOT((Reader)new StringReader(dotText), format, out);
    }

    public static void runDOT(File dotFile, String format, File out) throws IOException, FileNotFoundException {
        DOT.runDOT((Reader)new FileReader(dotFile), format, out);
    }

    public static void renderDOTExternal(Reader r, String format) {
        try {
            File image = File.createTempFile("dot", format);
            DOT.runDOT(r, format, image);
            Desktop.getDesktop().open(image);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error rendering DOT: " + e.getMessage(), "Error", 0);
        }
    }

    public static void renderDOTExternal(String dotText, String format) {
        DOT.renderDOTExternal(new StringReader(dotText), format);
    }

    public static void renderDOTExternal(File dotFile, String format) throws FileNotFoundException {
        DOT.renderDOTExternal(new FileReader(dotFile), format);
    }

    public static void renderDOT(Reader r, boolean modal) {
        DOTComponent cmp = DOT.createDOTComponent(r);
        if (cmp == null) {
            return;
        }
        final JDialog frame = new JDialog((Dialog)null, modal);
        JScrollPane scrollPane = new JScrollPane(cmp);
        frame.setContentPane(scrollPane);
        frame.setMaximumSize(new Dimension(800, 600));
        frame.pack();
        JMenu menu = new JMenu("File");
        menu.add(cmp.getSavePngAction());
        menu.add(cmp.getSaveDotAction());
        menu.addSeparator();
        menu.add(new AbstractAction("Close"){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setVisible(false);
            }
        });
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(menu);
        frame.setJMenuBar(menuBar);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
        frame.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    frame.setVisible(false);
                }
            }
        });
    }

    public static void renderDOT(String dotText, boolean modal) {
        DOT.renderDOT(new StringReader(dotText), modal);
    }

    public static void renderDOT(File dotFile, boolean modal) throws FileNotFoundException {
        DOT.renderDOT(new FileReader(dotFile), modal);
    }

    public static BufferedImage renderDOTImage(Reader dotReader) throws IOException {
        InputStream pngIs = DOT.runDOT(dotReader, "png", new String[0]);
        BufferedImage img = ImageIO.read(pngIs);
        pngIs.close();
        return img;
    }

    public static BufferedImage renderDOTImage(String dotText) throws IOException {
        return DOT.renderDOTImage(new StringReader(dotText));
    }

    public static BufferedImage renderDOTImage(File dotFile) throws IOException {
        return DOT.renderDOTImage(new BufferedReader(new FileReader(dotFile)));
    }

    public static DOTComponent createDOTComponent(Reader r) {
        try {
            DOTComponent dc = new DOTComponent(r);
            return dc;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Could not run DOT: " + e.getMessage(), "Failed to run DOT", 0);
            return null;
        }
    }

    public static Writer createDotWriter(final boolean modal) {
        return new StringWriter(){

            @Override
            public void close() throws IOException {
                DOT.renderDOT(this.getBuffer().toString(), modal);
                super.close();
            }
        };
    }
}

