/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.brics;

import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.Automaton;
import net.automatalib.automata.fsa.FiniteStateAcceptor;
import net.automatalib.automata.graphs.AbstractAutomatonGraphView;
import net.automatalib.brics.BricsTransitionProperty;
import net.automatalib.brics.BricsVisualizationHelper;
import net.automatalib.graphs.UniversalGraph;
import net.automatalib.graphs.concepts.GraphViewable;
import net.automatalib.visualization.VisualizationHelper;

@ParametersAreNonnullByDefault
public abstract class AbstractBricsAutomaton
implements FiniteStateAcceptor<State, Character>,
GraphViewable {
    protected final dk.brics.automaton.Automaton automaton;

    public AbstractBricsAutomaton(dk.brics.automaton.Automaton automaton, boolean totalize) {
        this.automaton = Objects.requireNonNull(automaton);
        if (totalize) {
            State s = new State();
            s.addTransition(new Transition('\u0000', '\uffff', s));
            for (State p : this.getStates()) {
                int maxi = 0;
                for (Transition t : p.getSortedTransitions(false)) {
                    if (t.getMin() > maxi) {
                        p.addTransition(new Transition((char)maxi, (char)(t.getMin() - '\u0001'), s));
                    }
                    if (t.getMin() + '\u0001' <= maxi) continue;
                    maxi = t.getMax() + '\u0001';
                }
                if (maxi > 65535) continue;
                p.addTransition(new Transition((char)maxi, '\uffff', s));
            }
        }
    }

    public dk.brics.automaton.Automaton getBricsAutomaton() {
        return this.automaton;
    }

    public boolean isAccepting(State state) {
        return state.isAccept();
    }

    public Collection<State> getTransitions(State state, @Nonnull Character input) {
        List transitions = state.getSortedTransitions(false);
        HashSet<State> result = new HashSet<State>();
        for (Transition t : transitions) {
            char min = t.getMin();
            if (input.charValue() < min) break;
            char max = t.getMax();
            if (input.charValue() > max) continue;
            result.add(t.getDest());
        }
        return result;
    }

    public Set<State> getInitialStates() {
        return Collections.singleton(this.automaton.getInitialState());
    }

    public Collection<State> getStates() {
        return this.automaton.getStates();
    }

    public GraphView graphView() {
        return new GraphView();
    }

    public class GraphView
    extends AbstractAutomatonGraphView<State, AbstractBricsAutomaton, Transition>
    implements UniversalGraph<State, Transition, Boolean, BricsTransitionProperty> {
        public GraphView() {
            super((Automaton)AbstractBricsAutomaton.this);
        }

        public Collection<Transition> getOutgoingEdges(State node) {
            return node.getTransitions();
        }

        public State getTarget(Transition edge) {
            return edge.getDest();
        }

        public VisualizationHelper<State, Transition> getVisualizationHelper() {
            return new BricsVisualizationHelper(AbstractBricsAutomaton.this);
        }

        public Boolean getNodeProperty(State node) {
            return node.isAccept();
        }

        public BricsTransitionProperty getEdgeProperty(Transition edge) {
            return new BricsTransitionProperty(edge);
        }
    }
}

