/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.brics;

import dk.brics.automaton.Transition;

public class BricsTransitionProperty {
    private final char min;
    private final char max;

    public static String toString(char min, char max) {
        StringBuilder sb = new StringBuilder();
        sb.append('\'').append(min).append('\'');
        if (max > min) {
            sb.append("..'").append(max).append('\'');
        }
        return sb.toString();
    }

    public BricsTransitionProperty(char min, char max) {
        this.min = min;
        this.max = max;
    }

    public BricsTransitionProperty(Transition trans) {
        this(trans.getMin(), trans.getMax());
    }

    public char getMin() {
        return this.min;
    }

    public char getMax() {
        return this.max;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.max;
        result = 31 * result + this.min;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BricsTransitionProperty other = (BricsTransitionProperty)obj;
        if (this.max != other.max) {
            return false;
        }
        return this.min == other.min;
    }

    public String toString() {
        return BricsTransitionProperty.toString(this.min, this.max);
    }
}

