/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.brics;

import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.util.Collection;
import java.util.Map;
import net.automatalib.brics.AbstractBricsAutomaton;
import net.automatalib.brics.BricsTransitionProperty;
import net.automatalib.graphs.dot.DefaultDOTHelper;

final class BricsDOTHelper
extends DefaultDOTHelper<State, Transition> {
    private final AbstractBricsAutomaton automaton;

    public BricsDOTHelper(AbstractBricsAutomaton automaton) {
        this.automaton = automaton;
    }

    protected Collection<? extends State> initialNodes() {
        return this.automaton.getInitialStates();
    }

    public boolean getNodeProperties(State node, Map<String, String> properties) {
        if (!super.getNodeProperties((Object)node, properties)) {
            return false;
        }
        String str = node.toString();
        int wsIdx1 = str.indexOf(32);
        int wsIdx2 = str.indexOf(32, wsIdx1 + 1);
        properties.put("label", "s" + str.substring(wsIdx1 + 1, wsIdx2));
        if (node.isAccept()) {
            properties.put("shape", "doublecircle");
        }
        return true;
    }

    public boolean getEdgeProperties(State src, Transition edge, State tgt, Map<String, String> properties) {
        if (!super.getEdgeProperties((Object)src, (Object)edge, (Object)tgt, properties)) {
            return false;
        }
        String label = BricsTransitionProperty.toString(edge.getMin(), edge.getMax());
        properties.put("label", label);
        return true;
    }
}

